package com.sap.caf.core.appsrv.doccontent;

import javax.ejb.EJBLocalObject;

import com.sap.caf.core.appsrv.datatypes.*;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.exception.ServiceException;

public interface DocContentLocal extends EJBLocalObject {

	public String copyDocument(String srcRid, String dstBOName, String dstBOGuid) throws CAFUpdateException;
	public String relateDocument(String srcRid, String dstBOName, String dstBOGuid) throws CAFUpdateException;		
	public String uploadDocument(String pathName, byte[] content) throws CAFCreateException;
	public String uploadExtLink(String pathName, String url) throws CAFCreateException;
	public boolean isAttached(String rid) throws CAFBaseException;
	public String addRelatedObjectRid(String documentKey, String boName, String boInstanceGuid, String boRid) throws CAFUpdateException;
	public void removeRelatedObjectRid(String documentKey, String boName, String boInstanceGuid) throws CAFUpdateException;
	
	public byte[] readDocumentContent(String documentKey) throws CAFRetrieveException;
	
//	versioning methods
	public boolean isDocumentLocked (String rid) throws ServiceException;
	public IDocumentLockInfo getLockInfo (String rid) throws ServiceException;
	public boolean unLockDocument (String rid) throws ServiceException;	
	public void disableDocumentVersioning(String rid) throws ServiceException;
	public void enableDocumentVersioning (String rid) throws ServiceException;
	public boolean isDocumentVersioned (String rid) throws ServiceException;
	public String[] getVersionHistory(String rid)throws ServiceException;
	public void setAsCurrentVersion (String historyRid, String rid) throws ServiceException;
	public void deleteVersion (String historyRid) throws ServiceException;
	public String getCurrentVersion(String rid) throws ServiceException;
	
}

