/*
 * Created on 31.05.2004
 *
 */
package com.sap.caf.core.appsrv.datatypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

/**
 * @author Vadzim_Karacharski
 *
 */
public class DocumentLockInfo implements IDocumentLockInfo, Serializable {
	
	protected String _objectName = "sap.com/caf.core/DocContent";	
	
	private String m_owner;
	private boolean m_allowUnlock;

	private static List propList = new ArrayList();
	static {
		propList.add("lockOwner");
		propList.add("allowUnlock");
	}

	public DocumentLockInfo(String lockOwner, boolean allowUnlock) {
		m_owner = lockOwner;
		m_allowUnlock = allowUnlock;
	}

	/**
	 * @see com.sap.caf.core.services.document.IDocumentLockInfo#getLockOwner()
	 */
	public String getLockOwner() {
		return m_owner;
	}
	
	public void setLockOwner(String lockOwner) {
		m_owner = lockOwner;
	}

	/**
	 * @see com.sap.caf.core.services.document.IDocumentLockInfo#allowUnlock()
	 */
	public boolean allowUnlock() {
		return m_allowUnlock;
	}
	
	public void setAllowUnlock(boolean allowUnlock) {
		m_allowUnlock = allowUnlock;
	}
	
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#getKey()
	 */
	public String getKey() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#getObjectType()
	 */
	public String getObjectType() {
		return _objectName;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#getPK()
	 */
	public AbstractPrimaryKey getPK() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#getProperty(java.lang.String)
	 */
	public Object getProperty(String propertyName) {
		Object prop = null; 
		if (propertyName.equals("lockOwner")) { prop =  this.getLockOwner();}
		else if (propertyName.equals("allowUnlock")) { prop = new Boolean(this.allowUnlock());}
		return prop;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#getPropertyList()
	 */
	public List getPropertyList() {
		return propList;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#setProperty(java.lang.String, java.lang.Object)
	 */
	public void setProperty(String propertyName, Object propertyValue) {
		if (propertyName.equals("lockOwner")) { this.setLockOwner((String)propertyValue);}
		else if (propertyName.equals("country")) { this.setAllowUnlock(((Boolean) propertyValue).booleanValue());}
	}
}
