package com.sap.caf.core.appsrv.currencyconversion;

import javax.ejb.SessionContext;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
import com.sap.caf.rt.srv.ApplicationServiceBean;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.security.srv.ServicePermission;

import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceLocal;
import com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceLocalHome;
import com.sap.caf.core.utils.HomeFactory;

//@@custom code start - [imports]
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.CAFFindException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import com.sap.caf.core.appsrv.datatypes.Amount;
import com.sap.caf.core.besrv.exchangerate.ExchangeRate;
//@@custom code end - [imports]

public class CurrencyConversionBean extends ApplicationServiceBean { //$JL-SER$

    public static final String PROVIDER = "sap.com";
    public static final String APPLICATION = "caf.core";
    public static final String APP_SRV_NAME = "CurrencyConversion";
    public static final String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + APP_SRV_NAME;
    public static final String JARM_REQUEST = "XAP:APPSERV:" + OBJECT_NAME;

    private static final Location location = Location.getLocation(CurrencyConversionBean.class);

//@@custom code start - [attributes]

//@@custom code end - [attributes]

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext context) {
        sessionContext = context;
    }

    public void ejbCreate() throws javax.ejb.CreateException {
        objectGuid = "1B56A7D1-3369-9A21-2F3D-D448B37E";
    }

//@@custom code start - [internal coding]

//@@custom code end - [internal coding]
		
    /**
     * Convert Currency
     * @param rateType Attribute.shortText
     * @param currencyFrom Attribute.shortText
     * @param currencyTo Attribute.shortText
     * @param date Attribute.shortText
     * @exception com.sap.caf.rt.exception.CAFFindException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.ArrayList convertCurrency(java.lang.String rateType, java.lang.String currencyFrom, java.lang.String currencyTo, java.sql.Date date) throws com.sap.caf.rt.exception.CAFFindException {
        // logging
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        java.lang.String methodHeader = "convertCurrency(java.lang.String, java.lang.String, java.lang.String, java.sql.Date)";		
        Object[] parameters = new Object[] {rateType, currencyFrom, currencyTo, date};
        CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);

        java.util.ArrayList retValue;
       
        try {
//@@custom code start - convertCurrency(java.lang.String, java.lang.String, java.lang.String, java.sql.Date)
  		try
  		{
			ExchangeRateServiceLocal exchangeRateServiceLocal = getExchangeRateService();
			retValue = exchangeRateServiceLocal.getExchangeRate(
					new QueryFilter(currencyFrom),
					new QueryFilter(currencyTo), 
					new QueryFilter(rateType), 
					new QueryFilter((new SimpleDateFormat("yyyy-MM-dd")).format(date))
					);			

  		}
  		catch (Exception e)
  		{
			throw new CAFFindException(e);
  		}
//@@custom code end - convertCurrency(java.lang.String, java.lang.String, java.lang.String, java.sql.Date)
        } finally {
            CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
        }

        return retValue;
    }

    /**
     * Convert Currency for today
     * @param currencyFrom Attribute.shortText
     * @param currencyTo Attribute.shortText
     * @exception com.sap.caf.rt.exception.CAFFindException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.ArrayList convertCurrencyForToday(java.lang.String currencyFrom, java.lang.String currencyTo) throws com.sap.caf.rt.exception.CAFFindException {
        // logging
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        java.lang.String methodHeader = "convertCurrencyForToday(java.lang.String, java.lang.String)";		
        Object[] parameters = new Object[] {currencyFrom, currencyTo};
        CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);

        java.util.ArrayList retValue;
       
        try {
//@@custom code start - convertCurrencyForToday(java.lang.String, java.lang.String)
  			
  			java.sql.Date currentDate = new java.sql.Date(java.lang.System.currentTimeMillis());
  			retValue = convertCurrency("M", currencyFrom, currencyTo, currentDate);
  			
//@@custom code end - convertCurrencyForToday(java.lang.String, java.lang.String)
        } finally {
            CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
        }

        return retValue;
    }

    /**
     * Convert Currency with structure parameters
     * @param amount Attribute.shortText
     * @param currencyTarget Attribute.shortText
     * @param date Attribute.shortText
     * @param rateType Attribute.shortText
     * @exception com.sap.caf.rt.exception.CAFFindException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.ArrayList convertCurrencyWithStructure(com.sap.caf.core.appsrv.datatypes.Amount amount, java.lang.String currencyTarget, java.sql.Date date, java.lang.String rateType) throws com.sap.caf.rt.exception.CAFFindException {
        // logging
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        java.lang.String methodHeader = "convertCurrencyWithStructure(com.sap.caf.core.appsrv.datatypes.Amount, java.lang.String, java.sql.Date, java.lang.String)";		
        Object[] parameters = new Object[] {amount, currencyTarget, date, rateType};
        CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);

        java.util.ArrayList retValue;
       
        try {
//@@custom code start - convertCurrencyWithStructure(com.sap.caf.core.appsrv.datatypes.Amount, java.lang.String, java.sql.Date, java.lang.String)
		  	
		  	Collection amountCollection = convertCurrency(rateType, amount.getCurrency(), currencyTarget, date);
  			retValue = new ArrayList();
			Amount amountResult = new Amount();
			
			ExchangeRate exchangeRate = (ExchangeRate)amountCollection.iterator().next();
			if (exchangeRate!=null){
				amountResult.setCurrency(currencyTarget);
				amountResult.setValue(exchangeRate.getExchangeRate().multiply(amount.getValue()));
			}
			
			retValue.add(amountResult); 
  			
//@@custom code end - convertCurrencyWithStructure(com.sap.caf.core.appsrv.datatypes.Amount, java.lang.String, java.sql.Date, java.lang.String)
        } finally {
            CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
        }

        return retValue;
    }

    private ExchangeRateServiceLocal getExchangeRateService() throws com.sap.caf.rt.exception.ServiceException {
        java.lang.String method = "getExchangeRateService()";
        java.lang.String jndiName = "localejbs/sap.com/caf.core/ExchangeRateService";
        java.lang.String user = sessionContext.getCallerPrincipal().getName();

    	ExchangeRateServiceLocal local = null;
        CAFPublicLogger.entering(user, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
        
        try {
            ExchangeRateServiceLocalHome localHome = (ExchangeRateServiceLocalHome) HomeFactory.getInstance().getLocalHome(jndiName);
            local = localHome.create();
        } catch (com.sap.caf.rt.exception.ServiceException se) {
            Object[] args = {jndiName};
            CAFPublicLogger.categoryCAF.logThrowableT(Severity.ERROR, location, method, "APPSRV_JNDI_LOOKUP_ERROR", args, se);
            location.throwing(method, se);
            throw new com.sap.caf.rt.exception.ServiceException(se);
        } catch (javax.ejb.CreateException e) {
            Object[] args = {method};
            CAFPublicLogger.traceThrowableT(Severity.DEBUG, location, method, "APPSRV_SIMPLE_ERROR", args, e);
            location.throwing(method, e);
            throw new com.sap.caf.rt.exception.ServiceException(e);
        } finally {
            CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, CAFPublicLogger.LEVEL_MEDIUM);
        }
        return local;
    }
    private void checkPermission(java.lang.String user, java.lang.String permission, java.lang.String methodHeader) throws com.sap.caf.rt.exception.CAFPermissionException {
        if (!CAFPermission.checkServicePermission(user, new ServicePermission(permission))) {
            CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, CAFPublicLogger.LEVEL_MEDIUM);
            throw new com.sap.caf.rt.exception.CAFPermissionException("APPSRV_AUTH_PERMISSION_ERROR", new Object[] {});
        }
    }

    public Object execute(String operationName, java.util.ArrayList parameters)	throws com.sap.caf.rt.exception.ServiceException {
	String method = "execute(String, ArrayList)";
	String user = sessionContext.getCallerPrincipal().getName();
	Object result = null;
	CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[] {operationName, parameters}, CAFPublicLogger.LEVEL_MEDIUM);
		if (operationName == null) {
		CAFPublicLogger.exiting(user, JARM_REQUEST, method, location);
		throw new com.sap.caf.rt.exception.ServiceException("APPSRV_NULL_OPERATION_ERROR");
	} else {
		try {
			if("".equals(operationName)){
				
			} else {				
				throw new com.sap.caf.rt.exception.ServiceException("Operation not defined");
			}
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.DEBUG, location, method, "Error in " + method, e);
			location.throwing(method, e);
			throw new com.sap.caf.rt.exception.ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[] {result}, CAFPublicLogger.LEVEL_MEDIUM);
		}
		return result;
	}
    }

}