package com.sap.caf.core.appsrv.classificationrefservice;

import java.util.Map;

import com.sap.caf.rt.srv.IService;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.core.appsrv.datatypes.ClassificationRef;

public interface ClassificationRefServiceLocal extends IService {

    /**
     * Business Methods
     */
    /**
     * createClassificationRef
     * @param refType Attribute.shortText
     * @param objectId Attribute.shortText
     * @param classificationId Attribute.shortText
     * @param taxonomyId Attribute.shortText
     * @exception ServiceException FaultMessage.shortText
     */
    public void createClassificationRef(java.lang.String refType, java.lang.String objectId, java.lang.String classificationId, java.lang.String taxonomyId) throws ServiceException;

    /**
     * deleteClassificationRef
     * @param refType Attribute.shortText
     * @param objectId Attribute.shortText
     * @param classificationId Attribute.shortText
     * @exception ServiceException FaultMessage.shortText
     */
    public void deleteClassificationRef(java.lang.String refType, java.lang.String objectId, java.lang.String classificationId) throws ServiceException;

    /**
     * taxonomyList
     * @param refType Attribute.shortText
     * @exception ServiceException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.Collection taxonomyList(java.lang.String refType) throws ServiceException;

    /**
     * classificationList
     * @param refType Attribute.shortText
     * @param objectId Attribute.shortText
     * @exception ServiceException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.Collection classificationList(java.lang.String refType, java.lang.String objectId) throws ServiceException;

	public java.util.Collection classifListForBO(String refType) throws ServiceException ;
	
	public java.util.Collection findAllClassifications(Map mapNameToFilter) throws ServiceException  ;
    
    /**
     * create
     * @return Attribute.shortText
     */
    public ClassificationRef create() ;

    /**
     * read
     * @param arg0 Attribute.shortText
     * @return Attribute.shortText
     */
    public ClassificationRef read(java.lang.String key) ;

    /**
     * update
     * @param classificationRef0 Attribute.shortText
     */
    public void update(ClassificationRef classificationRef) ;

    /**
     * delete
     * @param classificationRef0 Attribute.shortText
     */
    public void delete(ClassificationRef classificationRef) ;

}