package com.sap.caf.core.appsrv.classificationrefservice;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;

import com.sap.caf.core.appsrv.datatypes.ClassificationRef;
import com.sap.caf.core.besrv.category.Category;
import com.sap.caf.core.besrv.category.CategoryServiceLocal;
import com.sap.caf.core.besrv.category.CategoryServiceLocalHome;
import com.sap.caf.core.besrv.categoryvalue.CategoryValue;
import com.sap.caf.core.besrv.categoryvalue.CategoryValueServiceLocal;
import com.sap.caf.core.besrv.categoryvalue.CategoryValueServiceLocalHome;
import com.sap.caf.km.ejb.svc.idxsearch.IIndexSearchClassify;
import com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchLocalHome;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.security.srv.ServicePermission;
import com.sap.caf.rt.srv.ApplicationServiceBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
//@@custom code end - [imports]

public class ClassificationRefServiceBean extends ApplicationServiceBean {

    public static final String PROVIDER = "sap.com";
    public static final String APPLICATION = "classificationref";
    public static final String APP_SRV_NAME = "ClassificationRefService";
    public static final String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + APP_SRV_NAME;
    public static final String JARM_REQUEST = "XAP:APPSERV:" + OBJECT_NAME;

    private static final Location location = Location.getLocation(ClassificationRefServiceBean.class);
    private SessionContext sessionContext;

//@@custom code start - [attributes]
	private static final String JNDI_CATEGORY_NAME = "localejbs/sap.com/caf.tc/CategoryService";
	private static final String JNDI_CATEGORY_VALUE_NAME = "localejbs/sap.com/caf.tc/CategoryValueService";
	private static final String JNDI_INDEX_SEARCH_NAME = "localejbs/sap.com/caf~com.sap.caf.runtime/IndexSearchBean";
	
	private CategoryValueServiceLocal categoryValueService;
	private CategoryServiceLocal categoryService;
	
//@@custom code end - [attributes]

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext context) {
        sessionContext = context;
    }

    public void ejbCreate() throws CreateException {
        objectGuid = "208211DF1D0E888963EC8D933CA90DDD";
    }

//@@custom code start - [internal coding]
	private Object getServiceByType(String refType) throws ServiceException {
		java.lang.String user = sessionContext.getCallerPrincipal().getName();
		java.lang.String methodHeader = "getServiceByType(java.lang.String)";		
		Object[] parameters = new Object[] {refType};
		CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);  	
		try {
			String jndiName = "localejbs/" + refType;		
			Object homeRef = new InitialContext().lookup(jndiName);
			Method createMethod = homeRef.getClass().getMethod("create", new Class[]{});
			Object ejbRef = createMethod.invoke(homeRef, new Object[]{});
			return ejbRef;
		} catch (Exception e) {
			throw new ServiceException(e);
	  	}
	  	finally {
			CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
	  	}
  	}
  	
	private IIndexSearchClassify getClassifyBean() throws Exception {
		java.lang.String user = sessionContext.getCallerPrincipal().getName();
		java.lang.String methodHeader = "getClassifyBean()";		
		Object[] parameters = new Object[] {};
		CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);
		Context context = new InitialContext();
		IndexSearchLocalHome idxHome = (IndexSearchLocalHome)context.lookup(JNDI_INDEX_SEARCH_NAME);
		IIndexSearchClassify idxs = idxHome.create(); 
		CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
		return idxs;	
	}

    
	private Collection getCategoryClassifications(String guid, String refType) throws ServiceException {
		java.lang.String user = sessionContext.getCallerPrincipal().getName();
		java.lang.String methodHeader = "getCategoryClassifications(java.lang.String, java.lang.String)";		
		Object[] parameters = new Object[] {guid, refType};
		CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);
		Collection result = Collections.EMPTY_LIST;
		CategoryServiceLocal service = getCategoryService();
		try {
			Category currentCategory = service.read(guid);
			Collection values = currentCategory.getValues();
			if ((values == null) || (values.isEmpty())) {
				return result;
			}
			String taxonomy = currentCategory.getName();
			result = new ArrayList(values.size());
			for (Iterator iter = values.iterator(); iter.hasNext(); ) {
				String catValueKey = (String) iter.next();
				CategoryValue vo = getCategoryValueService().read(catValueKey);
				ClassificationRef bean = new ClassificationRef();
				bean.setClassificationID(vo.getKey());
				bean.setObjectID(null);
				bean.setRefType(refType);

				bean.setTaxonomy(taxonomy);
				bean.setTaxonomyID(guid);
				bean.setCategory(vo.getName());
				result.add(bean); 
			}
		} catch (Exception e) {
//			throw new ServiceException(e);
		} 
		finally {
			CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
		}
		return result;			
	}
	
	private CategoryServiceLocal getCategoryService() throws ServiceException {
		if(categoryService == null) {
			try {
				Context context = new InitialContext();
				CategoryServiceLocalHome categoryHome =  (CategoryServiceLocalHome) context.lookup(JNDI_CATEGORY_NAME);
				categoryService = categoryHome.create();
			}
			catch(Exception ex) {
				throw new ServiceException(ex);
			}
		}
		return categoryService;
	}
	
	private CategoryValueServiceLocal getCategoryValueService() throws Exception {
		if (categoryValueService == null) {
			Context context = new InitialContext();
			CategoryValueServiceLocalHome categoryHome =  (CategoryValueServiceLocalHome) context.lookup(JNDI_CATEGORY_VALUE_NAME);
			categoryValueService = categoryHome.create();
		}
		return categoryValueService;
	}
	
	private Collection getObjectClassifications(String refType, String objectID, String categoryID) throws ServiceException {
		java.lang.String user = sessionContext.getCallerPrincipal().getName();
		java.lang.String methodHeader = "getObjectClassifications(java.lang.String, java.lang.String, java.lang.String)";		
		Object[] parameters = new Object[] {refType, objectID, categoryID};
		CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);
		
		Collection result = Collections.EMPTY_LIST;
		CategoryServiceLocal service = getCategoryService();
		try {
			Category currentCategory = service.read(categoryID);
			String taxonomy = currentCategory.getName();
			Collection voGuids = getClassifyBean().getClassification(objectID, categoryID);
			result = new ArrayList(voGuids.size());
			for (Iterator iter = voGuids.iterator(); iter.hasNext(); ) {
				String voGuid = (String) iter.next();
				CategoryValue vo = getCategoryValueService().read(voGuid);
				ClassificationRef bean = new ClassificationRef();
				bean.setClassificationID(vo.getKey());
				bean.setObjectID(objectID);
				bean.setRefType(refType);

				bean.setTaxonomy(taxonomy);
				bean.setTaxonomyID(categoryID);
				bean.setCategory(vo.getName());
				result.add(bean); 
			}
		} catch (Exception e) {
//			throw new ServiceException(e);
		} 
		finally {
			CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
		}
		return result;			
	}
	
//@@custom code end - [internal coding]
		
    /**
     * createClassificationRef
     * @param refType Attribute.shortText
     * @param objectId Attribute.shortText
     * @param classificationId Attribute.shortText
     * @param taxonomyId Attribute.shortText
     * @exception ServiceException FaultMessage.shortText
     */
    public void createClassificationRef(java.lang.String refType, java.lang.String objectId, java.lang.String classificationId, java.lang.String taxonomyId) throws ServiceException {
        // logging
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        java.lang.String methodHeader = "createClassificationRef(java.lang.String, java.lang.String, java.lang.String, java.lang.String)";		
        Object[] parameters = new Object[] {refType, objectId, classificationId, taxonomyId};
        CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);
//@@custom code start - createClassificationRef(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
  		Object srv = getServiceByType(refType);
  		try {
  			Method addClsfMet = srv.getClass().getMethod("addClassification",
  			                new Class[] {String.class, String.class, String.class});
  			addClsfMet.invoke(srv, new Object[] {objectId, classificationId, taxonomyId});                
  		} 
  		catch (Exception e) {
			throw new ServiceException(e);	
  		}
  		finally {
  			CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
  		}
//@@custom code end - createClassificationRef(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
    }

    /**
     * deleteClassificationRef
     * @param refType Attribute.shortText
     * @param objectId Attribute.shortText
     * @param classificationId Attribute.shortText
     * @exception ServiceException FaultMessage.shortText
     */
    public void deleteClassificationRef(java.lang.String refType, java.lang.String objectId, java.lang.String classificationId) throws ServiceException {
        // logging
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        java.lang.String methodHeader = "deleteClassificationRef(java.lang.String, java.lang.String, java.lang.String)";		
        Object[] parameters = new Object[] {refType, objectId, classificationId};
        CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);
//@@custom code start - deleteClassificationRef(java.lang.String, java.lang.String, java.lang.String)
		Object srv = getServiceByType(refType);
		try {
			Method delClsfMet = srv.getClass().getMethod("removeClassification", new Class[] {String.class, String.class});
			delClsfMet.invoke(srv, new Object[] {objectId, classificationId});
		} catch (Exception e) {
			throw new ServiceException(e);	
		}
		finally {
			CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
		}
//@@custom code end - deleteClassificationRef(java.lang.String, java.lang.String, java.lang.String)
    }

    /**
     * taxonomyList returns list of all possible category values for specified service (reftype)
     * @param refType Attribute.shortText
     * @exception ServiceException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.Collection taxonomyList(java.lang.String refType) throws ServiceException {
        // logging
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        java.lang.String methodHeader = "taxonomyList(java.lang.String)";		
        Object[] parameters = new Object[] {refType};
        CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);

        java.util.Collection retValue;
        
//@@custom code start - taxonomyList(java.lang.String)
  		java.util.Collection categoryGuids = null;
		try {
			categoryGuids = getClassifyBean().getCategories(refType);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
		if ((categoryGuids == null) || (categoryGuids.isEmpty())) {
			return Collections.EMPTY_LIST;
		}
		retValue = new java.util.ArrayList(categoryGuids.size() * 10);
		for (java.util.Iterator iter = categoryGuids.iterator(); iter.hasNext(); ) {
			String guid = (String) iter.next();
			retValue.addAll(getCategoryClassifications(guid, refType));
		}
		CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
//@@custom code end - taxonomyList(java.lang.String)

        return retValue;
    }

    /**
     * classificationList returns list of assigned category values to the instance (objectId) of service (reftype) 
     * @param refType Attribute.shortText
     * @param objectId Attribute.shortText
     * @exception ServiceException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.Collection classificationList(java.lang.String refType, java.lang.String objectId) throws ServiceException {
        // logging
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        java.lang.String methodHeader = "classificationList(java.lang.String, java.lang.String)";		
        Object[] parameters = new Object[] {refType, objectId};
        CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);

        java.util.Collection retValue;
        
//@@custom code start - classificationList(java.lang.String, java.lang.String)
		Collection categoryGuids = null;
		try {
			categoryGuids = getClassifyBean().getCategories(refType);
		} catch (Exception e) {
			throw new ServiceException(e);
		} 
		if ((categoryGuids == null)	|| (categoryGuids.isEmpty())) {
			return Collections.EMPTY_LIST;	
		}
		retValue = new ArrayList(categoryGuids.size() * 10);
		for (Iterator iter = categoryGuids.iterator(); iter.hasNext(); ) {
			String categoryID = (String) iter.next();
			retValue.addAll(getObjectClassifications(refType, objectId, categoryID));
		}
		CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);
//@@custom code end - classificationList(java.lang.String, java.lang.String)
        return retValue;
    }

	public java.util.Collection classifListForBO(String refType) throws ServiceException {
		// logging
		java.lang.String user = sessionContext.getCallerPrincipal().getName();
		java.lang.String methodHeader = "classifListForAllBOs(String)";		
		Object[] parameters = new Object[] {refType};
		CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);

		java.util.Collection retValue;
		try{
			IIndexSearchClassify classifySrv = getClassifyBean() ;
			
			retValue = new ArrayList() ; 
			
			CategoryServiceLocal catSrv = getCategoryService();
			CategoryValueServiceLocal catValueSrv = getCategoryValueService() ;
			Collection assignment = classifySrv.getAssignedClassification(refType) ;

			for (Iterator iter = assignment.iterator(); iter.hasNext();){
				String[] row = (String[]) iter.next() ;
				ClassificationRef ref = new ClassificationRef() ;
				ref.setRefType(refType) ;
				ref.setObjectID(row[0]) ;
				ref.setTaxonomyID(row[2]) ;
				ref.setClassificationID(row[1]) ;
				ref.setTaxonomy(catSrv.read(row[2]).getName()) ;
				ref.setCategory(catValueSrv.read(row[1]).getName()) ;
				retValue.add(ref) ;
			}
		
		}catch(Exception e){
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				methodHeader,
				"Error in " + methodHeader,
				e);
			throw new ServiceException(e);
		}finally{
			CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);			
		}
		return retValue ;
	}


	public java.util.Collection findAllClassifications(Map mapNameToFilter) throws ServiceException {
		// logging
		java.lang.String user = sessionContext.getCallerPrincipal().getName();
		java.lang.String methodHeader = "findByMultipleParameters(Map)";		
		Object[] parameters = new Object[] {mapNameToFilter};
		CAFPublicLogger.entering(user, JARM_REQUEST, methodHeader, location, parameters);

		try{

			return classifListForBO(null) ;

		}catch(Exception e){
	
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				methodHeader,
				"Error in " + methodHeader,
				e);
	
			throw new ServiceException(e);
		}finally{
			CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, parameters);			
		}
	}

    /**
     * create
     * @return Attribute.shortText
     */
    public ClassificationRef create()  {
        return new ClassificationRef();
    }

    /**
     * read
     * @param arg0 Attribute.shortText
     * @return Attribute.shortText
     */
    public ClassificationRef read(java.lang.String key)  {
    	return new ClassificationRef();
    }

    /**
     * update
     * @param classificationRef0 Attribute.shortText
     */
    public void update(ClassificationRef classificationRef)  {
    }

    /**
     * delete
     * @param classificationRef0 Attribute.shortText
     */
    public void delete(ClassificationRef classificationRef)  {
    }

    private void checkPermission(java.lang.String user, java.lang.String permission, java.lang.String methodHeader) throws CAFPermissionException {
        if (!CAFPermission.checkServicePermission(user, new ServicePermission(permission))) {
            CAFPublicLogger.exiting(user, JARM_REQUEST, methodHeader, location, CAFPublicLogger.LEVEL_MEDIUM);
            throw new CAFPermissionException("APPSRV_AUTH_PERMISSION_ERROR", new Object[] {});
        }
    }


    public Object execute(String operationName, java.util.ArrayList parameters)	throws com.sap.caf.rt.exception.ServiceException {
	String method = "execute(String, ArrayList)";
	String user = sessionContext.getCallerPrincipal().getName();
	Object result = null;
	CAFPublicLogger.entering(user, JARM_REQUEST, method, location, new Object[] {operationName, parameters}, CAFPublicLogger.LEVEL_MEDIUM);
		if (operationName == null) {
		CAFPublicLogger.exiting(user, JARM_REQUEST, method, location);
		throw new com.sap.caf.rt.exception.ServiceException("APPSRV_NULL_OPERATION_ERROR");
	} else {
		try {
			if("".equals(operationName)){
				
			} else {				
				throw new com.sap.caf.rt.exception.ServiceException("Operation not defined");
			}
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.DEBUG, location, method, "Error in " + method, e);
			location.throwing(method, e);
			throw new com.sap.caf.rt.exception.ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(user, JARM_REQUEST, method, location, new Object[] {result}, CAFPublicLogger.LEVEL_MEDIUM);
		}
		return result;
	}

    }
}