package com.sap.caf.core;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.core.appsrv.doccontent.DocContentLocal;
import com.sap.caf.core.appsrv.doccontent.DocContentLocalHome;
import com.sap.caf.core.besrv.document.DocumentServiceLocal;
import com.sap.caf.core.besrv.document.DocumentServiceLocalHome;
import com.sap.caf.km.ejb.svc.kmcoll.bean.CollaborationLocal;
import com.sap.caf.km.ejb.svc.kmcoll.bean.CollaborationLocalHome;

/**
 * @author C5047347
 */
public class CoreServices {

	public static final String DOCUMENT_SERVICE_JNDI_NAME = "localejbs/sap.com/caf.core/DocumentService";
	public static final String DOCCONTENT_SERVICE_JNDI_NAME = "localejbs/sap.com/caf.core/DocContent";	
	
	public static final String DISCUSSION_ROOM_SERVICE_JNDI_NAME = "localejbs/sap.com/caf.core/DiscussionRoomService";
	public static final String DISCUSSION_SERVICE_JNDI_NAME = "localejbs/sap.com/caf.core/DiscussionService";
	public static final String TOPIC_SERVICE_JNDI_NAME = "localejbs/sap.com/caf.core/TopicService";
	
	public static final String COLLABORATION_SERVICE_JNDI_NAME = "localejbs/sap.com/caf~com.sap.caf.runtime/KMCollaborationSvc";
	
	private static Context m_initialContext;	

	/**
	 * Get DocumentService Bean
	 */
	public static DocumentServiceLocal getDocumentService() throws NamingException, CreateException {
		   Context ctx = getInitialContext();
		   DocumentServiceLocalHome home = (DocumentServiceLocalHome)ctx.lookup(DOCUMENT_SERVICE_JNDI_NAME);
		   return home.create();
	}

	/**
	 * Get DocContentService Bean
	 */
	public static DocContentLocal getDocContentService() throws NamingException, CreateException {
		   Context ctx = getInitialContext();
		   DocContentLocalHome home = (DocContentLocalHome)ctx.lookup(DOCCONTENT_SERVICE_JNDI_NAME);
		   return home.create();
	}

	
	/**
	 * Get CollaborationService Bean
	 */
	public static CollaborationLocal getCollaborationService() throws NamingException, CreateException {
		   Context ctx = getInitialContext(); 
		   CollaborationLocalHome home = (CollaborationLocalHome)ctx.lookup(COLLABORATION_SERVICE_JNDI_NAME);
		   return home.create();
	}
	
	private static Context getInitialContext() throws NamingException {
		if (m_initialContext==null) {
			m_initialContext = new InitialContext();
		}
		return m_initialContext;
	}
}
