/*
 * @(#) $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepositoryStructureManager.java#1 $
 *
 * Copyright(c) 2003, SAP AG, All Rights Reserved.
 */
package com.sap.tc.webdynpro.repository.api;

import java.util.Iterator;

/**
 * Manger repository structure.
 * The repository structure consists of customizing layers and variants.
 * The development component to be used for creating new objects is set by
 * the structure manager factory when creating the structure manager.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepositoryStructureManager.java#1 $
 */
public interface IWDRepositoryStructureManager {

  /**
   * Creates a new variant.
   * Precondition: hasVariant(name) == false
   * @param name name of the variant to create
   * @return the newly created variant
   */
  IWDVariant createVariant(String name);

  /**
   * Returns the specified variant.
   * @param name the name of the variant to return
   * @return the requested variant or null if hasVariant() == false.
   */
  IWDVariant getVariant(String name);

  /**
   * Returns true, iff the variant with the specified name exists.
   * @param name the name of the variant to be checked
   * @return true, iff the variant with the specified name exists
   */
  boolean hasVariant(String name);

  /**
   * Deletes the given variant.
   * The caller of the method is responsible to avoid orphan successor variants.
   * @param variant the variant to be deleted
   */
  void deleteVariant(IWDVariant variant);

  /**
   * Iterates over all known variants.
   * Currently, there is no specific order.
   * @return iterator over all known variants
   */
  Iterator iterateVariants();

  /**
   * Creates a new customizing layer.
   * Precondition: hasCustomizingLayer(name) == false
   * @param name name of the customizing layer to create
   * @return the newly created customizing layer
   */
  IWDCustomizingLayer createCustomizingLayer(String name);

  /**
   * Returns the specified customizing layer.
   * @param name name of the customizing layer to return
   * @return the requested customizing layer or null if hasCustomizingLayer() == false.
   */
  IWDCustomizingLayer getCustomizingLayer(String name);

  /**
   * Returns true, iff the customizing layer with the specified name exists.
   * @param name name of the customizing layer to check for
   * @return true, iff the customizing layer with the specified name exists
   */
  boolean hasCustomizingLayer(String name);

  /**
   * Deletes the given customizing layer.
   * The caller of the method is responsible to avoid orphan successor
   * customizing layers.
   * @param customizingLayer the customizing layer to be deleted
   */
  void deleteCustomizingLayer(IWDCustomizingLayer customizingLayer);

  /**
   * Iterates over all known customizing layers.
   * Currently, there is no specific order.
   * @return iterator over all known customizing layers   
   */
  Iterator iterateCustomizingLayers();

  /**
   * Persists all variant and customizing layer changes of this structure manager.
   */
  void commitChanges();
}
