/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepositoryModelClassInfo.java#1 $
 */

package com.sap.tc.webdynpro.repository.api;

import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIModelInfo;

/**
 * API of the metadata object of a repository model class.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository/java/com/sap/tc/webdynpro/repository/api/IWDRepositoryModelClassInfo.java#1 $
 */
public interface IWDRepositoryModelClassInfo extends ICMIModelClassInfo {

  /**
   * Returns the name of the model class info.
   * @return the name of the model class info 
   */
  public String getName();

  /**
   * Returns the associated model info.
   * @return the associated model info
   */
  public ICMIModelInfo getModelInfo();
}
