header {
package com.togethersoft.sca.internal.plugin.detect.compiler;
}

class StrategyParser extends Parser;
options {
	buildAST = false;
    	defaultErrorHandler = false;     // Don't generate parser error handlers
}

detectionRule returns [Expr e = null]
	:	e = expression
	;

expression returns [Expr e = null]
  	{ Expr e2 = null; }
	:	e = multiplicativeExpression
	(	"or" e2 = multiplicativeExpression 
		{ e = new BinaryExpr(BinaryExpr.OR, e, e2); }
	|	"butnotin" e2 = multiplicativeExpression
		{ e = new BinaryExpr(BinaryExpr.SUB, e, e2); }
	)*
	;

multiplicativeExpression returns [Expr e = null]
  	{ Expr e2 = null; }
	:	e = primaryExpression
	(	"and" e2 = primaryExpression
		{ e = new BinaryExpr(BinaryExpr.AND, e, e2); }
	)*
	;

primaryExpression returns [Expr e = null]
	{ String id = null; }
	:	LPAREN
	(	id = metric COMMA e = filter[id]
	| 	e = expression
	)
		RPAREN
	;

metric returns [String id = null]
	:	tkn:IDENT { id = tkn.getText(); }
	;

filter[String metric] returns [Expr e = null]
	:	"HigherThan" LPAREN i1:INT RPAREN
		{ e = new MetricExpr(MetricExpr.HIGHER_THAN, metric, i1.getText()); }
	|	"LowerThan" LPAREN i2:INT RPAREN
		{ e = new MetricExpr(MetricExpr.LOWER_THAN, metric, i2.getText()); }
	|	"TopValues" LPAREN i3:INT PERCENT RPAREN
		{ e = new MetricExpr(MetricExpr.TOP_VALUES, metric, i3.getText()); }
	|	"BottomValues" LPAREN i4:INT PERCENT RPAREN
		{ e = new MetricExpr(MetricExpr.BOTTOM_VALUES, metric, i4.getText()); }
	|	"BoxPlots"	
	;

class StrategyLexer extends Lexer;
options {
	testLiterals=false;    // don't automatically test for literals
}

WS	:	(' '
	|	'\t'
	|	'\n'
	|	'\r')
		{ _ttype = Token.SKIP; }
	;

LPAREN:	'(' ;

RPAREN:	')' ;

COMMA:	',' ;

PERCENT: '%' ;

INT:	('0'..'9')+ ;

// an identifier.  Note that testLiterals is set to true!  This means
// that after we match the rule, we look in the literals table to see
// if it's a literal or really an identifer
IDENT
	options {testLiterals=true;}
	:	('a'..'z'|'A'..'Z') ('a'..'z'|'A'..'Z'|'_'|'0'..'9'|'$')*
	;
