package com.sap.tc.loggingStandard;

/**
 * Title:        LoggingStandard
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      SAP Markets, Inc
 * @author
 * @version $Id: //sapmarkets/Logging/630_VAL_REL/src/_StdLogging1.3/java/com/sap/tc/loggingStandard/WLocation.java#2 $
 */

import java.lang.*;
import java.util.*;

import com.sap.tc.logging.*;

/**
 * <p>
 *   This class extends <code>com.sap.tc.logging.Location</code>.
 * </p>
 * <p>
 *   This internal wrapper is created to enable the message output logic
 *   comparable to that in the LogController class. This is necessary since the
 *   methods in the latter class is protected and Location objects are
 *   manufactured from the LogManager factory methods.
 * </p>
 * <p>
 *   This class follows the logic of message writing and propagation to parents,
 *   as in the SAP API. This is where SAP Log record get piped to the assigned
 *   Log destination.
 * </p>
 * <p>
 *   Note that the resulting message is written with SAP logging format.
 * </p>
 */
class WLocation extends Location{

  static String version = "$Id: //sapmarkets/Logging/630_VAL_REL/src/_StdLogging1.3/java/com/sap/tc/loggingStandard/WLocation.java#2 $";

  protected WLocation(Location loc){    //no parent info included
    super(loc.getName());
    this._origLoc = loc;
  }

/////////////////////////////////////////////////////////
// logST : logging methods complement to SUN standard API
////////////////////////////////////////////////////////

  //Master switch: take in WLogRecord
  private void logST(WLogRecord record){
  //TODO: can or do not need to beLogged again: this supposed to be a private method
    messageInt(record);
  }

  protected void logST(int      severity,
                  Category category,
                  String   classname,
                  String   methodname,
                  Object   msgCode,     //msgCode & msgClear:
                  String   rb,
                  String   msgClear) {  //mutually exclusive from caller assumed
                                        //or msgClear wins
    //TODO: in this case, no need to belogged Relative, veto anyway
    if (_origLoc.beLogged(severity, category)) {
      logST(new  WLogRecord(_origLoc,
                                 classname
                               + SEPARATOR
                               + methodname,
                               severity,
                               new String[] {category.getName()},
                               MsgType.PLAIN,
                               msgCode,
                               rb,
                               msgClear,
                               null));
    }
  }

  protected void logST(int      severity,
                  Category category,
                  String   classname,
                  String   methodname,
                  Object   msgCode,   //msgCode & msgClear:
                  String   rb,
                  String   msgClear,  //mutually exclusive from caller assumed
                                      //or msgClear wins
                  Object[] params) {
    //TODO: in this case, no need to belogged Relative, veto anyway
    if (_origLoc.beLogged(severity, category)) {
      logST(new  WLogRecord(_origLoc,
                                 classname
                               + SEPARATOR
                               + methodname,
                               severity,
                               new String[] {category.getName()},
                               MsgType.JAVA,
                               msgCode,
                               rb,
                               msgClear,
                               params));
    }
  }

  //Update return type: inherited from LogController
  protected LogRecord message(LogRecord rec) {
    LogRecord writtenRec = null;

    //beLogged(rec) is private
    if (_origLoc.beLogged(rec.getSeverity(),
                          (LogController[])rec.getRelatives().toArray(new LogController[0]))) {
      writtenRec = messageInt(rec);
    }
    return writtenRec;
  }

  //Update return type: inherited from LogController
  protected synchronized LogRecord messageInt(LogRecord rec) {
      final String method = "messageInt(LogRecord)";

      LogRecord writtenRec = null;

      classLoc.entering(method,
                        new Object[] {getName()});

      if (_origLoc.isFiltersAgreeing(rec)) {     //LOC
        classLoc.pathT(method,
                       "filters agreeing");
        Iterator iter;

        classLoc.pathT(method,
                       "write to ALL logs");
        iter = _origLoc.getLogs().iterator();  //API changed: this is only getting
                                               // 'normal' logs
        while (iter.hasNext()) {
          Log log = (Log) iter.next();
          classLoc.debugT(method,
                          "write to Normal log {0}",
                          new Object[] {log});
          if (log.write(rec) != null){
                        writtenRec = rec;
                  }
        }
        iter = _origLoc.getLocalLogs().iterator();
        while (iter.hasNext()) {
          Log log = (Log) iter.next();
          classLoc.debugT(method,
                          "write to Local log {0}",
                          new Object[] {log});
          if (log.write(rec) != null){
                        writtenRec = rec;
                  }
        }
        iter = _origLoc.getPrivateLogs().iterator();
        while (iter.hasNext()) {
          Log log = (Log) iter.next();
          classLoc.debugT(method,
                          "write to Private log {0}",
                          new Object[] {log});
          if (log.write(rec) != null){
                        writtenRec = rec;
                  }
        }
//        setLogged(true);
//        setLoggedLocal(true);
//        setLoggedPrivate(true);

        LogController parent = _origLoc.getParent();
        if (parent != null) {
          classLoc.pathT(method,
                         "propagate to parent");
          WLocation _pWLoc = new WLocation((Location)parent);
          if (_pWLoc.forwardMessage(rec) != null){
            writtenRec = rec;
                  }
        }
      } else {
        classLoc.pathT(method,
                       "filters vetoing");
      }


      classLoc.exiting();

      return writtenRec;

  }

  protected synchronized LogRecord forwardMessage(com.sap.tc.logging.LogRecord rec) {
    final String method = "forwardMessage(LogRecord)";

    classLoc.entering(method,
                      new Object[] {getName()});

    LogRecord writtenRec = null;

    Iterator iter;

    iter = _origLoc.getLogs().iterator();    //getLogs() ---> get 'normal' logs
    while (iter.hasNext()) {
      Log log = (Log) iter.next();
      classLoc.debugT(method,
                      "write to parent's Normal log {0}",
                       new Object[] {log});
      if (log.write(rec) != null){
        writtenRec = rec;
          }
    }
//    setLogged(true);

                                                        //beLogged(rec) is private
    if (_origLoc.beLogged(rec.getSeverity(),
                          (LogController[])rec.getRelatives().toArray(new LogController[0]))
        && _origLoc.isFiltersAgreeing(rec)) {
      classLoc.pathT(method,
                     "parent's filters agreeing");
      iter = _origLoc.getLocalLogs().iterator();
      while (iter.hasNext()) {
        Log log = (Log) iter.next();
        classLoc.debugT(method,
                        "write to parent's Local log {0}",
                        new Object[] {log});
        if (log.write(rec) != null){
          writtenRec = rec;
            }
      }
//      setLoggedLocal(true);
    }
    else{
      classLoc.pathT(method,
                     "parent's filters vetoing");
    }

    LogController parent = _origLoc.getParent();
    if (parent != null) {
       WLocation _pWLoc = new WLocation((Location)parent);
       if (_pWLoc.forwardMessage(rec) != null){
                 writtenRec = rec;
           }
    }

    classLoc.exiting();

    return writtenRec;
  }



//  protected Location getOrigLoc(){
//    return _origLoc;
//  }

  protected Location _origLoc;
  private static Location classLoc    = Location.getLocation(WLocation.class);
}