/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/wizards/EclipseRequestAdapter.java#1 $
 */

package com.sap.tc.jtools.jlint.eclipse.wizards;

import org.eclipse.core.resources.IProject;

import com.sap.tc.jtools.jlint.eclipse.extension.EclipseModule;
import com.sap.tc.jtools.jlint.eclipse.extension.IEclipseRequest;


/**
 * @author D037913
 */
public class EclipseRequestAdapter implements IEclipseRequest {

  private IProject project;
  private EclipseModule module;
  
  public EclipseRequestAdapter(IProject project, EclipseModule module) {
    this.project = project;
    this.module = module;
  }
  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.extension.IEclipseRequest#getProject()
   */
  public IProject getProject() {
    return project;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.extension.IEclipseRequest#testObjectCount()
   */
  public int testObjectCount() {
    return 0;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.extension.IEclipseRequest#getModule()
   */
  public EclipseModule getModule() {
    return module;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.extension.IEclipseRequest#setModule(com.sap.tc.jtools.jlint.eclipse.extension.EclipseModule)
   */
  public void setModule(EclipseModule module) {
    this.module = module;
  }
}
