/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/views/DocsActionDelegate.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.views;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.config.ShowHelpAction;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;

/**
 * Description of this class
 * 
 */
public class DocsActionDelegate implements IObjectActionDelegate {

  private String testName;

  /**
   * @see org.eclipse.ui.IActionDelegate#run(IAction)
   */
  public void run(IAction action) {
    Display.getDefault().asyncExec(new Runnable() {
      public void run() {
        new ShowHelpAction(JlinPlugin.getActiveWorkbenchShell(), testName).run();
      }
    });
  }

  /**
   * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
   */
  public void selectionChanged(IAction action, ISelection selection) {
    if (selection instanceof IStructuredSelection) {
      IStructuredSelection strucSel = (IStructuredSelection) selection;
      Object obj = strucSel.getFirstElement();
      if (obj instanceof IMarker) {
        IMarker marker = (IMarker) obj;
        try {
          testName =
            (String) marker.getAttribute(MetaMarkerManager.ATTR_TEST_NAME);
        } catch (CoreException e) {
          ExceptionHandler.handle(e);
          JlinPlugin.log(e);
        }
      }
    }
  }

  /**
   * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
   */
  public void setActivePart(IAction action, IWorkbenchPart targetPart) {
  }

}
