/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/validator/Validator.java#3 $
 */

package com.sap.tc.jtools.jlint.eclipse.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseResponse;
import com.sap.tc.jtools.jlint.eclipse.launch.JLinRunner;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.launch.MetaRequestManager;
import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.TestTreeNode;
import com.sap.tc.jtools.jtci.exceptions.PerformException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;

/**
 * @author d034036
 */
public class Validator {

	private static Map requestCache = new HashMap(); //ID --> request manager;
	
	public static ValidationResult validate(Object[] testObjects)
		throws PerformException {
		return validate(testObjects, null, null);
	}

	public static ValidationResult validate(
		String sessionID,
		IProgressMonitor monitor)
		throws PerformException {
		return validate(sessionID,(MetaRequestManager)requestCache.get(sessionID),monitor);
	}
	
	public static ValidationResult validate(
		Object[] testObjects,
		String[] testGroups,
		IProgressMonitor monitor)
		throws PerformException {

		String sessionID = Long.toString(System.currentTimeMillis());

		Test[] tests = getTests(testGroups);
		MetaRequestManager requestManager =
			new MetaRequestManager(tests, testObjects);
		requestCache.put(sessionID,requestManager);
		return validate(sessionID,requestManager,monitor);
	}
	
	private static ValidationResult validate(String sessionID, MetaRequestManager requestManager,
	IProgressMonitor monitor) {
			
		JLinRunner runner = new JLinRunner(requestManager, monitor, null, null);
		runner.run();

		EclipseResponse[] responses = runner.getResponses();
		List results = new ArrayList();
		for (int i = 0; i < responses.length; i++) {
			ResultInterface[] res =
					responses[i].getResponse().getResults();
			results.addAll(Arrays.asList(res));
		}
		ResultInterface[] resultArray =
			(ResultInterface[]) results.toArray(new Result[results.size()]);
		// build object --> result map
		Map object2Results = new HashMap();
		for (int i = 0; i < resultArray.length; i++) {
			Object selection = requestManager.getObject(resultArray[i]);
			if (selection == null) { //result can't be attributed
				continue;
			}
			List resultsForThisObject = (List) object2Results.get(selection);
			if (resultsForThisObject == null) {
				resultsForThisObject = new ArrayList();
				object2Results.put(selection, resultsForThisObject);
			}
			resultsForThisObject.add(resultArray[i]);
		}


		IMarker[] markers = null;
		
		MetaMarkerManager markerManager = runner.getMarkerManager();
		if ( markerManager != null ) {
			markers = markerManager.getMarkers();
		}
		return new ValidationResult(
			sessionID,
			resultArray,
			markers,
			object2Results);
	}

	/**
	 * @param testGroups
	 * @return
	 */
	private static Test[] getTests(String[] testGroups) {
		TestTree testTree = JLinSetupCache.getDispatcher().getTestTree();
		TestDescriptionInterface[] tdiArray;
		if (testGroups == null) {
			tdiArray = testTree.getAllLeaves();
		} else {
			List testList = new ArrayList();
			for (int i = 0; i < testGroups.length; i++) {
				StringTokenizer tokenizer =
					new StringTokenizer(testGroups[i], "/");
				testList.addAll(getTests(tokenizer, testTree));
			}
			tdiArray =
				(TestDescriptionInterface[]) testList.toArray(
					new TestDescriptionInterface[testList.size()]);
		}

		List outList = new ArrayList();
		for (int i = 0; i < tdiArray.length; i++) {
			if (isComplete(tdiArray[i])) {
				outList.add(
					new Test(
						tdiArray[i].getName(),
						tdiArray[i].getInputParameters()));
			}
		}
		return (Test[]) outList.toArray(new Test[outList.size()]);
	}

	private static List getTests(StringTokenizer tokenizer, TestTree tree) {
		if (!tokenizer.hasMoreTokens()) {
			List out = new ArrayList();
			TestDescriptionInterface[] descriptions = tree.getAllLeaves();
			for (int i = 0; i < descriptions.length; i++) {
				out.add(descriptions[i]);
			}
			return out;
		} else { //recursive descent
			String currentToken = tokenizer.nextToken();
			TestTreeNode[] nodes = tree.getNodes();
			for (int i = 0; i < nodes.length; i++) {
				if (nodes[i].getNodeType() == TestTreeNode.TREE
					&& ((TestTree) nodes[i]).getName().equals(currentToken)) {
					return getTests(tokenizer, (TestTree) nodes[i]);
				}
			}
		}
		return new ArrayList();
	}

	private static boolean isComplete(TestDescriptionInterface testDescription) {
		ParameterInterface[] params = testDescription.getInputParameters();
		for (int i = 0; i < params.length; i++) {
			if (params[i].getValue() == null) {
				return false;
			}
		}
		return true;
	}

}
