/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/validator/ValidationResult.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.validator;

import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IMarker;

import com.sap.tc.jtools.jtci.interfaces.ResultInterface;

/**
 * @author d034036
 */
public class ValidationResult {
	private String sessionID;
	private ResultInterface[] results;
	private IMarker[] markers;
	private Map object2ResultsMap;

	public ValidationResult(
		String sessionID,
		ResultInterface[] results,
		IMarker[] markers,
		Map object2ResultsMap) {
		this.sessionID = sessionID;
		this.results = results;
		this.markers = markers;
		this.object2ResultsMap = object2ResultsMap;
	}
	/**
	 * @return
	 */
	public ResultInterface[] getResults() {
		return results;
	}

	/**
	 * @return
	 */
	public String getSessionID() {
		return sessionID;
	}

	/**
	 * @return
	 */
	public IMarker[] getMarkers() {
		return markers;
	}

	public ResultInterface[] getResults(Object testedObject) {
		Object resultSet = object2ResultsMap.get(testedObject);
		if (resultSet == null)
			return new ResultInterface[0];
		return (ResultInterface[]) ((List) resultSet).toArray(
			new ResultInterface[0]);
	}

}
