/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/validator/Action.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.validator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.sap.tc.jtools.jtci.interfaces.ResultInterface;

/**
 * @author d034036
 */
public class Action extends org.eclipse.jface.action.Action implements IWorkbenchWindowActionDelegate{

	private Object[] selection;
 	private static String lastSession;

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IAction#getId()
	 */
	public String getId() {
		return "com.sap.tc.jtools.jlint.eclipse.validator.Action";
	}

 

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IAction#isEnabled()
	 */
	public boolean isEnabled() {
		return true;
	}

 
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		// TODO Auto-generated method stub
		super.run();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IAction#runWithEvent(org.eclipse.swt.widgets.Event)
	 */
	public void runWithEvent(Event event) {
		// TODO Auto-generated method stub
		super.runWithEvent(event);
	}

  

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		System.out.println("Action ID: " + action.getId());
		long start = System.currentTimeMillis();
		try{
			ValidationResult result = null;
			if ( action.getId().equals("com.sap.tc.jtools.jlint.eclipse.validator.Action")) {
				result = Validator.validate(selection);
				lastSession = result.getSessionID();
			} else {
				if (lastSession != null ) {
					result = Validator.validate(lastSession,null);			
				}

			}
 
			System.out.println("found " + result.getResults().length + "results");					
			for (int i = 0; i < selection.length; i++) {
				ResultInterface[] results = result.getResults(selection[i]);
				if ( results != null ) {
					System.out.println("selection n. " + i + ": " + results.length + " errors found.");					
				}

			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		long stop = System.currentTimeMillis();		
		System.out.println("total duration: " + (stop-start) + " ms");
		return;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if ( selection instanceof IStructuredSelection) {
			this.selection = ((IStructuredSelection)selection).toArray();
		}
	}



	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub
		
	}



	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub
		
	}

}
