/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/util/ResponseTransformatorTool.java#1 $
 */

package com.sap.tc.jtools.jlint.eclipse.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import com.sap.tc.jtools.jlint.eclipse.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.extension.EclipseModule;
import com.sap.tc.jtools.jlint.eclipse.extension.IEclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseResponse;
import com.sap.tc.jtools.jlint.eclipse.wizards.EclipseRequestAdapter;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;

/**
 * @author D037913
 *  
 */
public class ResponseTransformatorTool {

  private static ExtensionManager manager = ExtensionManager
                                              .getExtensionManager();

  private ResponseTransformatorTool() {
  }

  public static EclipseResponse[] transform(PerformResponse response,
      IProject correspondingProject) {
    return transform(response, correspondingProject, null);
  }

  public static EclipseResponse[] transform(PerformResponse response,
      IProject correspondingProject, IProgressMonitor monitor) {
    Map module2ResultsMap = new HashMap();
    ResultInterface[] results = response.getResults();
    for (int i = 0; i < results.length; i++) {
      EclipseModule module = manager.getModuleForTestObjectType(results[i]
          .getTestObjectType());
      if (module == null) {
        continue;
      }
      List resultList = (List) module2ResultsMap.get(module);
      if (resultList == null) {
        resultList = new ArrayList();
        module2ResultsMap.put(module, resultList);
      }
      resultList.add(results[i]);
    }
    Set entries = module2ResultsMap.entrySet();
    List eclipseResponseList = new ArrayList(entries.size());
    if (monitor != null) {
      monitor.beginTask("Transforming results", entries.size());
    }
    try {
      for (Iterator iter = entries.iterator(); iter.hasNext();) {
        if (monitor != null) {
          monitor.worked(1);
        }
        Map.Entry entry = (Map.Entry) iter.next();
        List resultList = (List) entry.getValue();
        PerformResponse newResponse = new PerformResponse("");
        for (Iterator iterator = resultList.iterator(); iterator.hasNext();) {
          newResponse.addResult((ResultInterface) iterator.next());
        }
        IEclipseRequest dummyRequest = new EclipseRequestAdapter(
            correspondingProject, (EclipseModule) entry.getKey());
        eclipseResponseList.add(new EclipseResponse(dummyRequest, newResponse));
      }
    } finally {
      if (monitor != null) {
        monitor.done();
      }
    }
    return (EclipseResponse[]) eclipseResponseList
        .toArray(new EclipseResponse[0]);
  }
}
