/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/util/JLinSetupCache.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.util;

import com.sap.tc.jtools.jlint.eclipse.ExtensionManager;
import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jtci.Dispatcher;
import com.sap.tc.jtools.jtci.cache.Cache;

final public class JLinSetupCache {
  static private Dispatcher fgDispatcher = null;
  final static private char[] fgSema = { 'x' };
  static private final boolean withCache = false;

  // no instanciation at all
  private JLinSetupCache() {
  }

  /** 
   * Returns the default JLin dispatcher
   */
  public static Dispatcher getDispatcher() {
    Exception ex = null;
    synchronized (fgSema) {
      if (null == fgDispatcher) {
        try {
          return fgDispatcher =
            new Dispatcher(ExtensionManager.getExtensionManager().getTestProvider(),withCache? new Cache(): null);
        } catch (Exception e) {
          ex = e;
        }
      } else {
        return fgDispatcher;
      }
    }
    JlinPlugin.log(ex);
    ExceptionHandler.handle(ex);
    return null;
  }

  /** 
   * Frees any cached information
   */
  public static void freeCache() {
    synchronized (fgSema) {
      fgDispatcher = null;
    }
  }
}