/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/util/ExceptionHandler.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.util;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;

/**
 * Handles exceptions or errors caught.
 */
public class ExceptionHandler {

  /**
   * no initalization of this class
   */
  private ExceptionHandler() {
  }

  /**
   * Pops up a warning
   */
  public static void handle(
    final Throwable pThrowable,
    final String pTitle,
    final String pInfo) {

    if (pThrowable instanceof ThreadDeath) {
      throw (ThreadDeath) pThrowable;
    }

    if (pThrowable instanceof InterruptedException) {
      return;
    }

    if (null == pThrowable) {
      debuglog(pThrowable);
    }
    JlinPlugin.log(pThrowable);

    Runnable runnable = new Runnable() {
      public void run() {
        MessageBox box =
          new MessageBox(
            new Shell(),
            SWT.ICON_ERROR | SWT.CANCEL | SWT.SYSTEM_MODAL);
        box.setText(pTitle);
        if (null == pThrowable) {
          box.setMessage(pInfo);
        } else {
          String msg = pThrowable.getMessage();
          if (msg == null) {
            msg = "";
          }
          box.setMessage(pInfo + msg);
        }

        box.open();
      }
    };
    Display dsp = Display.getDefault();
    if (dsp != null) {
      dsp.asyncExec(runnable);
    } else {
      System.err.println(pInfo + pThrowable.getMessage());
    }
  }

  /**
   * Pops up a warning
   */
  public static void handle(Throwable t) {
    JlinPlugin.log(t);
    handle(
      t,
      TextKeyUtil.ERROR_SHOW_TITLE.getText(),
      TextKeyUtil.ERROR_SHOW_MESSAGE.getFormattedText(
        new String[] {
          t.toString(),
          Platform.getLogFileLocation().toString()})); 
  }

  /**
   * Log the specified exception and make sure all exceptions are handled..
   */
  private static void debuglog(Throwable t) {
    if (JlinPlugin.inDebugMode()) {
      try {
        // For the status object, use the exception's message, or the exception name if no message.
        JlinPlugin.log(t);
      } catch (Throwable bad) {
        System.err.println("Error during logging exception"); //$NON-NLS-1$
        bad.printStackTrace();
      }
    }
  }
}
