/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/resource/TextTool.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.resource;


import java.text.MessageFormat;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;

/**
 * global access point for text data to make internatialization easier
 */
public class TextTool {

  private static ResourceBundle fgResourceBundle= null;

  /* get resource during class initialization (if possible)           */
  static {
    try {
     fgResourceBundle= ResourceBundle.getBundle(
       "com.sap.tc.jtools.jlint.eclipse.resource.text.TextResource"); //$NON-NLS-1$
    } catch (java.util.MissingResourceException me) {
      JlinPlugin.log(me);
      fgResourceBundle= null;
    }
  }

  private TextTool() {
  }

  public static String getString(AbstractTextKey pKey) {
    try {
      return fgResourceBundle.getString(pKey.fTextId);
    } catch (MissingResourceException me) {
      return '!' + pKey.fTextId + '!';
    } catch (NullPointerException ne) {
      return "!!" + pKey.fTextId + "!!"; //$NON-NLS-1$ //$NON-NLS-2$
    }
  }
  
  public static String getFormattedString(
    AbstractTextKey pKey, 
    String pArg0) {
    if (null == pArg0) {
      pArg0= ""; //$NON-NLS-1$
    }
      
    try {
      return MessageFormat.format(
        fgResourceBundle.getString(pKey.fTextId),new String[] {pArg0});
    } catch (MissingResourceException me) {
      return 
        "!" + pKey.fTextId + "!" + pArg0; //$NON-NLS-1$ //$NON-NLS-2$
    } catch (NullPointerException ne) {
      return 
        "!!" + pKey.fTextId + "!!" + pArg0; //$NON-NLS-1$ //$NON-NLS-2$
    }
  }
  
  public static String getFormattedString(
    AbstractTextKey pKey, 
    String[] pArgs) {
    try {
      return MessageFormat.format(fgResourceBundle.getString(pKey.fTextId),pArgs);  
    } catch (MissingResourceException me) {
      String argsTxt= ""; //$NON-NLS-1$
      for (int ii=0; ii<pArgs.length; ii++) {
        if (null != pArgs[ii]) {
          argsTxt= argsTxt + ", " + pArgs[ii]; //$NON-NLS-1$
        }
      }
      return 
       "!" + pKey.fTextId + "!" + argsTxt; //$NON-NLS-1$ //$NON-NLS-2$
    } catch (NullPointerException ne) {
      String argsTxt= ""; //$NON-NLS-1$
      for (int ii=0; ii<pArgs.length; ii++) {
        if (null != pArgs[ii]) {
          argsTxt= argsTxt + ", " + pArgs[ii]; //$NON-NLS-1$
        }
      }
      return 
        "!!" + pKey.fTextId + "!!" + argsTxt; //$NON-NLS-1$ //$NON-NLS-2$
    }
  }  
}