/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/resource/IconTool.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.resource;

import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

import org.eclipse.swt.widgets.Display;

/**
 * global access point for icon data to seperate usage and knowledege of their
 * location
 */
public class IconTool {

  /**
   * @param   pDisplay      the display to create icon within
   *           pRelativePath relative location of icon to IconTool class
   * @return  new Image
   * @see     Image
   */
  static public Image create(Display pDisplay,String pRelativePath) {
    return new Image(pDisplay,createData(pRelativePath));
  }

  /**
   * @param   pRelativePath relative location of icon to IconTool class
   * @return  new ImageData for the specified path
   * @see     ImageData
   */
   static public ImageData createData(String pRelativePath) {
     return new ImageData(IconTool.class.getResourceAsStream(pRelativePath));
   }
   
  /**
   * @param   pRelativePath relative location of icon to IconTool class
   * @return  new ImageDescriptor for the specified path
   * @see     ImageDescriptor
   */
  static public ImageDescriptor createDescriptor(String pRelativePath) {
    return ImageDescriptor.createFromFile(IconTool.class,pRelativePath);
  }
}