/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/resource/AbstractTextKey.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.resource;

/**
 * defines text keys into resource bundle
 * this class is used instead of strings to get a better means for cross
 * references
 */
public abstract class AbstractTextKey {
  protected final String fTextId;
  
  public AbstractTextKey(String pTextId) {
    fTextId= pTextId;
  }

  /**
   * @see TextTool#getString
   */
  public final String getText() {
    return TextTool.getString(this);
  }

  /**
   * @see TextTool#getFormattedString
   */
  public final String getFormattedText(String pArg) {
    return TextTool.getFormattedString(this, pArg);
  }

  /**
   * @see TextTool#getFormattedString
   */
  public final String getFormattedText(String[] pArgs) {
    return TextTool.getFormattedString(this, pArgs);
  }
}
