/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/resource/AbstractIconKey.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.resource;

import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

import org.eclipse.swt.widgets.Display;

/**
 * defines keys for icon ressources
 * this class is used instead of strings to get a better means for cross
 * references
 * @version   $Date: 2004/03/22 $
 * @author    BPL Tools
 */
public abstract class AbstractIconKey{

  protected final String fRelativePath;
  boolean fCreateDummy;
  
  public AbstractIconKey(String pRelativePath, boolean pCreateDummy) {
    fRelativePath = pRelativePath;
    fCreateDummy = pCreateDummy;
  }

  /**
   * @param   pDisplay      the display to create icon within
   * @return  new Image or null if not present
   * @see     IconTool#create()
   */

  public Image create(Display pDisplay) {
    ImageData imageData = createData();
    if (null != imageData) {
      return new Image(pDisplay,imageData);
    } else {
      return null;
    }
  }

  /**
   * @return  new ImageData, a 16*16 pixel dummy or null
   * @see     IconTool#createData()
   */
  public ImageData createData() {
    java.io.InputStream inputStream = 
     IconTool.class.getResourceAsStream(fRelativePath);
    if (null != inputStream) { 
      return new ImageData(inputStream);
    } else {
      if (fCreateDummy) {
        PaletteData redPalette = new PaletteData(128,0,0);
        return new ImageData(16,16,16,redPalette);
      } else {
        return null;
      }
    }
  }
   
  /**
   * @return  new ImageDescriptor
   * @see     IconTool#createDescriptor()
   */
  public ImageDescriptor createDescriptor() {
    return ImageDescriptor.createFromFile(IconTool.class,fRelativePath);
  }
}
