/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/metadata/J2EEBeanMetaData.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.metadata;

import org.eclipse.jdt.core.IType;

 

/**
 * @author d034036
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class J2EEBeanMetaData implements IMetaData {

	public static final String TYPE = "J2EE_BEAN";

	private IType remoteInterface;
	private IType beanClass;
	private IType homeInterface;
	private IType localInterface;
	private IType localHomeInterface;

	public J2EEBeanMetaData(
		IType remote,
		IType bean,
		IType home,
		IType local,
		IType localHome) {

		this.remoteInterface = remote;
		this.beanClass = bean;
		this.homeInterface = home;
		this.localInterface = local;
		this.localHomeInterface = localHome;

	}

	/**
	 * @return
	 */
	public IType getBeanClass() {
		return beanClass;
	}

	/**
	 * @return
	 */
	public IType getHomeInterFace() {
		return homeInterface;
	}

	/**
	 * @return
	 */
	public IType getLocalInterface() {
		return localInterface;
	}

	/**
	 * @return
	 */
	public IType getLocalHomeInterface() {
		return localHomeInterface;
	}

	/**
	 * @return
	 */
	public IType getRemoteInterface() {
		return remoteInterface;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.eclipse.extension.IMetaData#getObjectType()
	 */
	public String getObjectType() {
		return TYPE;
	}


}
