/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/metadata/EJBAPMetaData.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.metadata;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;

 

/**
 * @author d034036
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class EJBAPMetaData implements IMetaData {

	public static final String TYPE = "EJB_AP";

	private IFile ejbDescriptorFile;
	private IFile engineDescriptorFile;
	private IFile persistenceDescriptorFile;
	private IFile ejbJarFile;
	private IJavaProject javaProject;
	private Object selection;

	/**
	 * @param descriptorFile
	 * @param webSErvicesDescriptor
	 * @param ejbJarFile
	 */
	public EJBAPMetaData(
		IJavaProject javaProject,
		IFile descriptorFile,
		IFile engineDescriptorFile,
		IFile persistenceDescriptorFile,
		IFile ejbJarFile,
		Object selection) {
		this.javaProject = javaProject;
		this.ejbDescriptorFile = descriptorFile;
		this.engineDescriptorFile = engineDescriptorFile;
		this.persistenceDescriptorFile = persistenceDescriptorFile;
		this.ejbJarFile = ejbJarFile;
		this.selection = selection;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.eclipse.extension.IMetaData#getObjectType()
	 */
	public String getObjectType() {
		return TYPE;
	}

	/**
	 * @return
	 */
	public IFile getEjbDescriptorFile() {
		return ejbDescriptorFile;
	}

	/**
	 * @return
	 */
	public IFile getEjbJarFile() {
		return ejbJarFile;
	}

	/**
	 * @return
	 */
	public IFile getEngineDescriptorFile() {
		return engineDescriptorFile;
	}

	/**
	 * @return
	 */
	public IJavaProject getJavaProject() {
		return javaProject;
	}

	/**
	 * @return
	 */
	public IFile getPersistenceDescriptorFile() {
		return persistenceDescriptorFile;
	}

	/**
	 * @return
	 */
	public Object getSelection() {
		return selection;
	}

}
