/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/launch/VariantSelection.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.launch;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import com.sap.tc.jtools.jlint.eclipse.config.JLinPreferencePage;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;

/**
 * Allows the selection of a variant, which is a container for the setup of JLIN tests.
 * @version   $Date: 2004/03/22 $
 * @author   BPL Tools
 */

public class VariantSelection {

  String fVariantName = null;

  /**
   * Constructor for VariantSelection.
   */
  public VariantSelection() {
    super();
  }

  /**
   * Constructor for VariantSelection.
   */
  public void show(Shell pShell) {

    ElementListSelectionDialog dialog =
      new ElementListSelectionDialog(pShell, new LabelProvider());
    String[] variants = JLinPreferencePage.getTestSets();
    if (null == variants || 0 == variants.length) {
      IllegalStateException is = new IllegalStateException("No Variant"); //$NON-NLS-1$
      ExceptionHandler.handle(is);
    }
    dialog.setElements(variants);
    dialog.setTitle(TextKeyLaunch.CHOOSE_VARIANT_TITLE.getText());
    dialog.setMessage(TextKeyLaunch.CHOOSE_VARIANT_MESSAGE.getText());
    dialog.setMultipleSelection(false);
    if (dialog.OK == dialog.open()) {
      fVariantName = (String) dialog.getFirstResult();
    }

  }

  /**
   * @return result null or name of variant chosen
   **/
  public String getResult() {
    return fVariantName;
  }

}
