/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/launch/MarkerPosition.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.launch;

import org.eclipse.core.resources.IResource;

import com.sap.tc.jtools.jlint.eclipse.extension.IMarkerPosition;

/**
 * @author D037913
 */
public class MarkerPosition implements IMarkerPosition {

  private IResource resource;
  private int line;
  private int column;

  public MarkerPosition(IResource resource, int line, int column) {
    this.resource = resource;
    this.line = line;
    this.column = column;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.extension.IMarkerPosition#getResource()
   */
  public IResource getResource() {
    return resource;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.extension.IMarkerPosition#getLine()
   */
  public int getLine() {
    return line;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.extension.IMarkerPosition#getColumn()
   */
  public int getColumn() {
    return column;
  }

}
