/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/launch/LaunchShortcutImpl.java#4 $
 */

package com.sap.tc.jtools.jlint.eclipse.launch;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.config.JLinPreferencePage;
import com.sap.tc.jtools.jlint.eclipse.config.TestSetTool;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;

/**
 * @author d037913
 */
public class LaunchShortcutImpl implements ILaunchShortcut {

	/**
	 * @see org.eclipse.debug.ui.ILaunchShortcut#launch(ISelection, String)
	 */
	public void launch(ISelection selection, String mode) {
		if (selection.isEmpty()) {
			MetaRequestManager.warnNoSources();
			return;
		}
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection sSelection = (IStructuredSelection) selection;
			Test[] tests = showVariantDialog();
			MetaRequestManager reqMan = new MetaRequestManager(tests, sSelection.toArray());
			runTests(reqMan);
		}
	}

	/**
	 * @see org.eclipse.debug.ui.ILaunchShortcut#launch(IEditorPart, String)
	 */
	public void launch(IEditorPart editor, String mode) {
		IEditorInput input = editor.getEditorInput();
		IFile file = (IFile) input.getAdapter(IFile.class);
		if (file == null) {
			MetaRequestManager.warnNoSources();
			return;
		}
		Test[] tests = showVariantDialog();
		MetaRequestManager reqMan = new MetaRequestManager(tests, new Object[] { file }); 
		runTests(reqMan);
	}

	private Test[] showVariantDialog() {
		Test[] tests = null;
		VariantSelection vs = new VariantSelection();
		Shell shell = JlinPlugin.getActiveWorkbenchShell();
		if (null == shell) {
			Display display = new Display();
			shell = new Shell(display);
		}
		vs.show(shell);
		String testSetName = vs.getResult();
		if (null == testSetName || 0 == testSetName.length()) {
			return null;
		}
		try {
			TestSet set = TestSetTool.readTestSet(testSetName);
			if (set != null) {
				tests = set.getActiveTests();
			}
		} catch (IOException io) {
			JlinPlugin.log(io);
			ExceptionHandler.handle(
				io,
				io.getClass().getName(),
				TextKeyLaunch.ACTIVE_TEST_EXC.getText() + io.getMessage());
		} catch (BadTreeException bt) {
			JlinPlugin.log(bt);
			ExceptionHandler.handle(
				bt,
				bt.getClass().getName(),
				TextKeyLaunch.ACTIVE_TEST_EXC.getText() + bt.getMessage());
		}

		if (null == tests || 0 == tests.length) {
			Exception illegalState = new IllegalStateException(""); //$NON-NLS-1$
			ExceptionHandler.handle(
				illegalState,
				TextKeyLaunch.VARIANT_CONTENT_TITLE.getText(),
				TextKeyLaunch.VARIANT_CONTENT_MESSAGE.getText());
			return null;
		}
		return tests;
	}

	private void runTests(MetaRequestManager requestMan) {
		String[] outOfSyncProjects = requestMan.getOutOfSyncProjectNames();
		if (outOfSyncProjects.length > 0) {
		  MetaRequestManager.warnProjectsOutOfSync(outOfSyncProjects);
		  return;
		}
		if (requestMan.testObjectCount()	== 0) {
			MetaRequestManager.warnNoSources();
			return;
		}
		try {
			ProgressMonitorDialog dlg =
				new ProgressMonitorDialog(JlinPlugin.getActiveWorkbenchShell());
			String resultsDir = null;
			if (JLinPreferencePage.exportResult()) {
				resultsDir = JLinPreferencePage.getResultExportDirName();
			}
			dlg.run(
				true,
				true,
				new JLinRunner(
					requestMan,
					null,
					JlinPlugin.getBaseDir().toString(),
					resultsDir));
		} catch (InvocationTargetException e) {
			JlinPlugin.log(e);
			ExceptionHandler.handle(e);
		} catch (InterruptedException e) {
			JlinPlugin.log(e);
			ExceptionHandler.handle(e);
		}
	}

}
