/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/launch/LaunchDelegate.java#3 $
 */

package com.sap.tc.jtools.jlint.eclipse.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.config.JLinPreferencePage;
import com.sap.tc.jtools.jlint.eclipse.config.TestSetTool;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.Test;

/**
 * @author d037913
 */
public class LaunchDelegate extends AbstractJavaLaunchConfigurationDelegate {

	/**
	 * Constructor for LaunchDelegate.
	 */
	public LaunchDelegate() {
		super();
	}

	/**
	 * @see org.eclipse.debug.core.model.ILaunchConfigurationDelegate#launch(ILaunchConfiguration, String, ILaunch, IProgressMonitor)
	 */
	public void launch(
		final ILaunchConfiguration configuration,
		String mode,
		ILaunch launch,
		IProgressMonitor monitor)
		throws CoreException {
	  try {
		Test tests[] = null;

		String variantName = LaunchTab.getTestSetName(configuration);

		if (null == variantName || 0 == variantName.length()) {
			VariantSelection vs = new VariantSelection();
			Shell shell = JlinPlugin.getActiveWorkbenchShell();
			if (null == shell) {
				Display display = new Display();
				shell = new Shell(display);
			}
			vs.show(shell);
			variantName = vs.getResult();
			if (null == variantName && 0 != variantName.length()) {
				return;
			}
			if (configuration instanceof ILaunchConfigurationWorkingCopy) {
				((ILaunchConfigurationWorkingCopy) configuration).setAttribute(
					LaunchTab.ATTR_TESTSET_NAME,
					variantName);
			}
		}

		try {
			tests = TestSetTool.readTestSet(variantName).getActiveTests();
		} catch (Exception e) {
			ExceptionHandler.handle(e);
		}

		if (null == tests || 0 == tests.length) {
			Exception illegalState = new IllegalStateException(""); //$NON-NLS-1$
			ExceptionHandler.handle(
				illegalState,
				TextKeyLaunch.VARIANT_CONTENT_TITLE.getText(),
				TextKeyLaunch.VARIANT_CONTENT_MESSAGE.getText());
			return;
		}
		IJavaElement el = getJavaElement(configuration);
		if (el == null)
			return;
		MetaRequestManager requestMan =
			new MetaRequestManager(tests, new Object[] { el });
		String resultsDir = null;
		if (JLinPreferencePage.exportResult()) {
			resultsDir = JLinPreferencePage.getResultExportDirName();
		}

		new JLinRunner(
			requestMan,
			monitor,
			JlinPlugin.getBaseDir().toString(),
			resultsDir)
			.run();
	  } finally {
	    // remove launch from launch list in debug view
	    getLaunchManager().removeLaunch(launch);
	  }
	}

	/**
	 * @param configuration
	 * @return
	 */
	private IJavaElement getJavaElement(ILaunchConfiguration configuration) {
		try {
			return JavaCore.create(
				configuration.getAttribute(LaunchTab.CONTAINER_ATTR, ""));
		} catch (CoreException e) {
			ExceptionHandler.handle(e);
			return null;
		}
	}

}
