/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/launch/LaunchConfigurationTabGroup.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.launch;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;


public class LaunchConfigurationTabGroup
  extends AbstractLaunchConfigurationTabGroup {
  /**
   * @see ILaunchConfigurationTabGroup#createTabs(ILaunchConfigurationDialog, String)
   */
  public void createTabs(
    ILaunchConfigurationDialog dialog,
    String mode) {
    ILaunchConfigurationTab[] tabs =
      new ILaunchConfigurationTab[] {
        new LaunchTab(),
        };
    setTabs(tabs);
  }

  /**
   * @see ILaunchConfigurationTabGroup#setDefaults(ILaunchConfigurationWorkingCopy)
   */
  public void setDefaults(ILaunchConfigurationWorkingCopy config) {
    super.setDefaults(config);
    config.setAttribute(
      IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE,
      (String) null);
    
  }
}
