/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/launch/EclipseResponse.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import com.sap.tc.jtools.jlint.eclipse.extension.IEclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * @author D037913
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class EclipseResponse {

  private PerformResponse response;
  private IEclipseRequest request;

  public EclipseResponse(IEclipseRequest request, PerformResponse response) {
    this.response = response;
    this.request = request;
  }

  public IEclipseRequest getRequest() {
    return request;
  }

  public PerformResponse getResponse() {
    return response;
  }

  public void saveTo(File file) {
    FileWriter writer = null;
    try {
      writer = new FileWriter(file);
      XMLTool.writeDocument(response.toStructureTree(), new BufferedWriter(writer));
    } catch (IOException e) {
      ExceptionHandler.handle(e);
    } finally {
      if (writer != null) {
        try {
          writer.close();
        } catch (IOException e) {
          ExceptionHandler.handle(e);
        }
      }
    }
  }

}
