/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/launch/EclipseRequest.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import com.sap.tc.jtools.jlint.eclipse.extension.IEclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator;
import com.sap.tc.jtools.jlint.eclipse.extension.EclipseModule;
import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * Description of this class
 * 
 * @author Jan Sievers
 * @version $Revision: #2 $ $Date: 2004/03/22 $
 */
public abstract class EclipseRequest extends PerformRequest implements IEclipseRequest {

  private IRequestCreator requestCreator;

	public static final EclipseRequest[] EMPTY_REQUEST_ARRAY = new EclipseRequest[0];

  private EclipseModule module;

  public EclipseRequest(String name, Test[] tests) {
    super(name);
    for (int i = 0; i < tests.length; i++) {
      addTest(tests[i]);
    }
  }

  public final EclipseModule getModule() {
    return module;
  }

  public final void setModule(EclipseModule module) {
    this.module = module;
  }

  public void saveTo(File file) {
		FileWriter writer= null;
    try {
      writer = new FileWriter(file);
      XMLTool.writeDocument(toStructureTree(), new BufferedWriter(writer));
    } catch (IOException e) {
      ExceptionHandler.handle(e);
    } finally {
      if (writer != null) {
        try {
          writer.close();
        } catch (IOException e) {
          ExceptionHandler.handle(e);
        }
      }
    }
  }

}
