/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/launch/AbstractLaunchConfigTab.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;

import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.*;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractLaunchConfigTab
  extends AbstractLaunchConfigurationTab {

  /**
   * Returns the current Java element context from which to initialize
   * default settings, or <code>null</code> if none.
   * 
   * @return Java element context.
   */
  protected IJavaElement getContext() {
    IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
    if (page != null) {
      ISelection selection = page.getSelection();
      if (selection instanceof IStructuredSelection) {
        IStructuredSelection ss = (IStructuredSelection) selection;
        if (!ss.isEmpty()) {
          Object obj = ss.getFirstElement();
          if (obj instanceof IJavaElement) {
            return (IJavaElement) obj;
          }
          if (obj instanceof IResource) {
            IJavaElement je = JavaCore.create((IResource) obj);
            if (je == null) {
              IProject pro = ((IResource) obj).getProject();
              je = JavaCore.create(pro);
            }
            if (je != null) {
              return je;
            }
          }
        }
      }
      IEditorPart part = page.getActiveEditor();
      if (part != null) {
        IEditorInput input = part.getEditorInput();
        return (IJavaElement) input.getAdapter(IJavaElement.class);
      }
    }
    return null;
  }

  /**
   * Set the java project attribute based on the IJavaElement.
   */
  protected void initializeJavaProject(
    IJavaElement javaElement,
    ILaunchConfigurationWorkingCopy config) {
    IJavaProject javaProject = javaElement.getJavaProject();
    String name = null;
    if (javaProject != null && javaProject.exists()) {
      name = javaProject.getElementName();
    }
    config.setAttribute(
      IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME,
      name);
  }

  protected void setButtonGridData(Button button) {
    GridData gridData = new GridData();
    button.setLayoutData(gridData);
    SWTUtil.setButtonDimensionHint(button);
  }

}