/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/extension/ISelectionHandler.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.extension;

import com.sap.tc.jtools.jlint.eclipse.metadata.IMetaData;


/**
 * Implementors of this interface map from a selection
 * of GUI objects in eclipse to model data and metadata
 * that is needed by the IRequestCreators.
 * Each GUI-type (e.g. Selena) has a specific implementation.
 * 
 * @author D037913
 */
public interface ISelectionHandler {
	
  /** sets the GUI selection */
	public void setSelection(Object[] selectedObjects);
	
  /** returns whether this ISelectionHandler can handle this object */
	public boolean canHandleObject(Object obj);
	
  /** return the data needed by IRequestCreators */
	public Object[] getData();
	
  /** return the metadata needed by IRequestCreators */
	public IMetaData[] getMetaData();
	
	public Object getSelection(Object dataItem);
	
}
