/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/extension/IRequestCreator.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.extension;

import org.eclipse.core.resources.IResource;

import com.sap.tc.jtools.jlint.eclipse.launch.EclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.metadata.IMetaData;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObjectPosition;

/**
 * Implementors of this interface create JLin-module specific  
 * EclipseRequest(s) from data and metaData which is provided
 * by an ISelectionHandler.
 *   
 * @author D037913
 */
public interface IRequestCreator {

	/** add to data from which to create requests*/
	public void addData(Object[] data);

	/** add to metadata from which to create requests*/
	public void addMetaData(IMetaData[] metaData);

	/** clear data and metadata */
	public void reset();

	/** create requests from data and metadata */
	public EclipseRequest[] createRequests(Test[] tests);

	/** get the IResources corresponding to data and metadata */
	public IResource[] getResources();

	/** returns all data associated with a given test object position*/
	public Object getData(String testObjectID, TestObjectPosition testObjectPosition);

}
