/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/extension/IMarkerPosition.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.extension;

import org.eclipse.core.resources.IResource;

/**
 * Represents a location (IResource, line, column) where JLin will create a 
 * org.eclipse.core.resources.IMarker that will appear in the Tasks view
 * as a JLin marker.
 * 
 * @author D037913
 */
public interface IMarkerPosition {

  /** IResource of this Position */	
	public IResource getResource();
	
  /** optional line (may be -1) */ 
	public int getLine();
	
  /** optional column (may be -1) */ 
	public int getColumn();

}
