/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/extension/IMarkerManager.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.extension;

import org.eclipse.core.resources.IProject;
import com.sap.tc.jtools.jtci.TestObjectPosition;

/**
 * Implementors of this interface are used to map from
 * a JLin-module specific implementation of 
 * com.sap.tc.jtools.jtci.TestObjectPosition in a JLin 
 * result to an eclipse IResource (plus optional line and column)
 * where an org.eclipse.core.resources.IMarker will be created
 * that will appear in the Tasks view as a JLin marker.
 * 
 * @author D037913
 */
public interface IMarkerManager {

  /**
   * return an IMarkerPosition corresponding to the 
   * given TestObjectPosition 
   */
  public IMarkerPosition getMarkerPosition(
    TestObjectPosition position,
    IProject correspondingProject);

}
