/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/extension/EclipseModule.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.extension;

import java.util.Map;

import com.sap.tc.jtools.jlint.extension.Module;

/**
 * This class is the runtime representation of a JLin module 
 * that has been declared using the eclipse extension point 
 * "com.sap.tc.jtools.jlin.module".
 * 
 * Each module has one IRequestCreator that creates module-specific
 * JLin requests and one IMarkerManager that maps JLin results to
 * eclipse markers.
 *  
 * @author D037913
 */
public class EclipseModule extends Module {

  private IMarkerManager markerManager;
  private IRequestCreator requestCreator;

  public EclipseModule(
    String id,
    ClassLoader moduleLoader,
    Map name2testObjClassName,
    IMarkerManager markerManager,
    IRequestCreator requestCreator) {
    super(id, moduleLoader, name2testObjClassName);
    this.markerManager = markerManager;
    this.requestCreator = requestCreator;
  }

  public IMarkerManager getMarkerManager() {
    return markerManager;
  }

  public IRequestCreator getRequestCreator() {
    return requestCreator;
  }

}
