/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/config/TextKeyCfg.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.config;

import com.sap.tc.jtools.jlint.eclipse.resource.AbstractTextKey;

/**
 * centralized management of native language strings
 * @version 	1.0, $Date: 2004/03/22 $
 * @author    BPL Tools
 */

class TextKeyCfg extends AbstractTextKey {

  public final static TextKeyCfg BASE_SHOW_VARIANT_ACTION =
    new TextKeyCfg("cfg.110");  //$JL-I18N$

  public final static TextKeyCfg BASE_EDIT_VARIANT_ACTION =
    new TextKeyCfg("cfg.111");                                    //$NON-NLS-1$

  public final static TextKeyCfg BASE_COPY_VARIANT_ACTION = 
    new TextKeyCfg("cfg.112");                                    //$NON-NLS-1$
    
  public final static TextKeyCfg BASE_DELETE_VARIANT_ACTION =
    new TextKeyCfg("cfg.113");                                    //$NON-NLS-1$

  public final static TextKeyCfg VARIANT_LABEL =
    new TextKeyCfg("cfg.116");                                    //$NON-NLS-1$

  public final static TextKeyCfg SHOW_BUTTON=
    new TextKeyCfg("cfg.117");                                    //$NON-NLS-1$

  public final static TextKeyCfg EDIT_BUTTON=
    new TextKeyCfg("cfg.118");                                    //$NON-NLS-1$

  public final static TextKeyCfg REMOVE_BUTTON=
    new TextKeyCfg("cfg.119");                                    //$NON-NLS-1$

  public final static TextKeyCfg COPY_BUTTON=
    new TextKeyCfg("cfg.120");                                    //$NON-NLS-1$

  public final static TextKeyCfg NEW_BUTTON=
    new TextKeyCfg("cfg.121");                                    //$NON-NLS-1$

  public final static TextKeyCfg USE_EXT_DESCR_LABEL =
    new TextKeyCfg("cfg.123");                                    //$NON-NLS-1$

  public final static TextKeyCfg BROWSE_LABEL =
    new TextKeyCfg("cfg.124");                                    //$NON-NLS-1$

  public final static TextKeyCfg DIRDIALOG_TEXT =
    new TextKeyCfg("cfg.125");                                    //$NON-NLS-1$

  public final static TextKeyCfg EXPORT_BUTTON =
    new TextKeyCfg("cfg.126");                                    //$NON-NLS-1$



  public final static TextKeyCfg VARIANT_SHOW_TITLE = 
    new TextKeyCfg("cfg.200");                                    //$NON-NLS-1$

  public final static TextKeyCfg VARIANT_EDIT_TITLE = 
    new TextKeyCfg("cfg.201");                                    //$NON-NLS-1$

  public final static TextKeyCfg VARIANT_SHOW_TEST_ACTION =
    new TextKeyCfg("cfg.210");                                    //$NON-NLS-1$
            
  public final static TextKeyCfg VARIANT_EDIT_TEST_ACTION =
    new TextKeyCfg("cfg.211");                                    //$NON-NLS-1$



  public final static TextKeyCfg TEST_SHOW_TITLE = 
    new TextKeyCfg("cfg.300");                                    //$NON-NLS-1$

  public final static TextKeyCfg TEST_EDIT_TITLE = 
    new TextKeyCfg("cfg.301");                                    //$NON-NLS-1$

  public final static TextKeyCfg TEST_SET_DEFAULT_ACTION =
    new TextKeyCfg("cfg.310");                                    //$NON-NLS-1$

  public final static TextKeyCfg TEST_APPEND_VALUE_ACTION =
    new TextKeyCfg("cfg.311");                                    //$NON-NLS-1$

  public final static TextKeyCfg TEST_REMOVE_VALUE_ACTION = 
    new TextKeyCfg("cfg.312");                                    //$NON-NLS-1$

  public final static TextKeyCfg TEST_EDIT_VALUE_ACTION = 
    new TextKeyCfg("cfg.313");                                    //$NON-NLS-1$

  public final static TextKeyCfg TEST_SHOW_HELP_ACTION = 
    new TextKeyCfg("cfg.314");                                    //$NON-NLS-1$

  public final static TextKeyCfg TEST_SHOW_HELP_RESPONSIBLE = 
    new TextKeyCfg("cfg.315");                                    //$NON-NLS-1$

  public final static TextKeyCfg TEST_SHOW_HELP_VERSION = 
    new TextKeyCfg("cfg.316");                                    //$NON-NLS-1$

	public final static TextKeyCfg TEST_SHOW_HELP_PSEUDO_CMT = 
		new TextKeyCfg("cfg.317");                                    //$NON-NLS-1$


  public final static TextKeyCfg ENTER_VALUE_TITLE = 
    new TextKeyCfg("cfg.910");                                    //$NON-NLS-1$

  public final static TextKeyCfg ENTER_VALUE_HELP = 
    new TextKeyCfg("cfg.911");                                    //$NON-NLS-1$

  public final static TextKeyCfg ENTER_VALUE_EMPTY_WARN = 
    new TextKeyCfg("cfg.912");                                    //$NON-NLS-1$

  public final static TextKeyCfg ENTER_VALUE_XML_WARN =   
    new TextKeyCfg("cfg.913");                                    //$NON-NLS-1$

  public final static TextKeyCfg BLANK_PARAM =   
    new TextKeyCfg("cfg.914");                                    //$NON-NLS-1$

  public final static TextKeyCfg ENTER_VALUE_FLOAT_WARN =   
    new TextKeyCfg("cfg.915");                                    //$NON-NLS-1$

  public final static TextKeyCfg ENTER_VALUE_INT_WARN=   
    new TextKeyCfg("cfg.916");                                    //$NON-NLS-1$

  public final static TextKeyCfg IO_ERROR_TITLE =    
    new TextKeyCfg("cfg.920");                                    //$NON-NLS-1$

  public final static TextKeyCfg IO_ERROR_MESSAGE = 
    new TextKeyCfg("cfg.921");                                    //$NON-NLS-1$

  public final static TextKeyCfg PARSE_ERROR_TITLE =         
    new TextKeyCfg("cfg.922");                                    //$NON-NLS-1$

  public final static TextKeyCfg PARSE_ERROR_MESSAGE =    
    new TextKeyCfg("cfg.923");                                    //$NON-NLS-1$


  public final static TextKeyCfg NEW_VARIANT_TITLE =    
    new TextKeyCfg("cfg.930");                                    //$NON-NLS-1$

  public final static TextKeyCfg NEW_VARIANT_MESSAGE =
    new TextKeyCfg("cfg.931");                                    //$NON-NLS-1$

  public final static TextKeyCfg NEW_VARIANT_NO_NAME =       
    new TextKeyCfg("cfg.932");                                    //$NON-NLS-1$

  public final static TextKeyCfg NEW_VARIANT_ILLEGAL_CHAR =
    new TextKeyCfg("cfg.933");                                    //$NON-NLS-1$

  public final static TextKeyCfg NEW_VARIANT_FILE_EXISTS =
    new TextKeyCfg("cfg.934");                                    //$NON-NLS-1$

  public final static TextKeyCfg SHOW_HELP_TITLE =
    new TextKeyCfg("cfg.940");                                    //$NON-NLS-1$

  public final static TextKeyCfg SHOW_HELP_NONE_THERE =
    new TextKeyCfg("cfg.941");                                    //$NON-NLS-1$

  public final static TextKeyCfg SHOW_HELP_ACTION =
    new TextKeyCfg("cfg.942");                                    //$NON-NLS-1$


  ///////////////////////////////////////////////////////////////////////////

  /** no instanciation for this class outside itself                          */
  private TextKeyCfg(String pKeyValue) {
    super(pKeyValue);
  }
}
