/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/config/ShowHelpAction.java#3 $
 */

package com.sap.tc.jtools.jlint.eclipse.config;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import com.sap.tc.jtools.jlint.eclipse.util.JLinSetupCache;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;

/**
 *  Displays a Dialog with additinal information to one test
 */

public class ShowHelpAction extends Action {
  final Shell fShell;
  final String testName;

  public ShowHelpAction(Shell pShell, String testName) {
    super(TextKeyCfg.SHOW_HELP_ACTION.getText());
    this.testName = testName;
    fShell = pShell;
  }

  public void run() {
    String helpText = null;
    TestDescriptionInterface[] tests =
      JLinSetupCache.getDispatcher().getTests();
    if (null != tests) {
      for (int i = 0; i < tests.length; i++) {
        if (testName.equals(tests[i].getName())) {
          StringBuffer help = new StringBuffer();
          help.append(tests[i].getDescription() + "\n");
          ParameterInterface pseudoComment =
            tests[i].getInternalParameter(
					"PSEUDO_COMMENT_SUFFIX");
          if (pseudoComment != null) {
            String comment =
                "//$JL-"
                + ((String) pseudoComment.getValue()).trim().toUpperCase()
                + "$";
            help.append(
              "\n"//$NON-NLS-1$
                + TextKeyCfg.TEST_SHOW_HELP_PSEUDO_CMT.getFormattedText(comment)
                + " .\n");//$NON-NLS-1$
          }
          help.append(
            "\n"
              + TextKeyCfg.TEST_SHOW_HELP_RESPONSIBLE.getText()
              + tests[i].getTestResponsible()
              + "\n");
          help.append(
            "\n"
              + TextKeyCfg.TEST_SHOW_HELP_VERSION.getText()
              + tests[i].getVersion()
              + "\n");
          helpText = help.toString();
          break;
        }
      }
    }
    if (null == helpText || 1 > helpText.length()) {
      helpText = TextKeyCfg.SHOW_HELP_NONE_THERE.getText();
    }

    String[] labels = new String[] { IDialogConstants.PROCEED_LABEL };

    MessageDialog dlg =
      new MessageDialog(
        fShell,
        testName,
        null,
        helpText,
        MessageDialog.INFORMATION,
        labels,
        0);
    dlg.open();

  }
}