/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/config/NewVariantNameDialog.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.config;

import java.io.File;

import org.eclipse.swt.widgets.Shell;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;

/**
 * dialog to enter the name of new variants.
 * @see InputDialog
 * @version   1.0, $Date: 2004/03/22 $
 * @author    BPL Tools
 */
final class NewVariantNameDialog extends InputDialog {

  /*
   * @see InputDialog#InputDialog()
   */
  public NewVariantNameDialog(Shell pParent, String pInitialValue) {
    super(
      pParent,
      TextKeyCfg.NEW_VARIANT_TITLE.getText(),
      TextKeyCfg.NEW_VARIANT_MESSAGE.getText(),
      pInitialValue,
      new NewVariantValidator());
  }
}

/** internal class for input validation */
class NewVariantValidator implements IInputValidator {
  final File fBaseDir = JlinPlugin.getBaseDir().toFile();

  public String isValid(String pInput) {

    // content required 
    if (0 == pInput.length()) {
      return TextKeyCfg.NEW_VARIANT_NO_NAME.getText();
    }

    String nameLower = pInput.toLowerCase();
    // only base chars
    char[] content = nameLower.toCharArray();
    for (int i = 0; i < content.length; i++) {
      if (0 > "abcdefghijklmnopqrstuvwxyz1234567890".indexOf(content[i])) { //$NON-NLS-1$
        return TextKeyCfg.NEW_VARIANT_ILLEGAL_CHAR.getText();
      }
    }

    // non existance
    File fp =
      new File(fBaseDir, nameLower + TestSetTool.TESTSET_EXTENSION);
    if (fp.exists()) {
      return TextKeyCfg.NEW_VARIANT_FILE_EXISTS.getText();
    }
    return null;
  }
}