/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/config/JLinPreferencePage.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.config;

import java.io.IOException;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;

/**
 * Preference page for JVer & Plugin settings. 
 * @version   1.0, $Date: 2004/03/22 $
 * @author    BPL Tools
 */
public final class JLinPreferencePage
  extends PreferencePage
  implements IWorkbenchPreferencePage {

  TestSetComposite fTabVariant;

  /**
   * constructor
   */
  public JLinPreferencePage() {
    super();
    setPreferenceStore(JlinPlugin.getDefault().getPreferenceStore());
  }

  /*
   * @see IWorkbenchPreferencePage#init(IWorkbench)
   */
  public void init(IWorkbench workbench) {
    if (null == workbench) {
      // suppress compiler warning 
    }
  }

  /**
   * @see PreferencePage#createControl(Composite)
   */
  public void createControl(Composite pParentComposite) {
    noDefaultAndApplyButton();
    super.createControl(pParentComposite);
  }

  /**
   * @see PreferencePage#createContents(Composite)
   */
  protected Control createContents(Composite pParentComposite) {
    createMyContent(pParentComposite);
    return pParentComposite;
  }

  public static String getDefaultTestSetName() {
    return TestSetTool.DEFAULT_NAME;
  }

  public static String[] getTestSets() {
    try {
      String[] vn1 = TestSetTool.scanTestSetNames();
      if (null == vn1) {
        return new String[] { TestSetTool.DEFAULT_NAME };
      } else {
        String[] vn2 = new String[vn1.length + 1];
        System.arraycopy(vn1, 0, vn2, 1, vn1.length);
        vn2[0] = TestSetTool.DEFAULT_NAME;
        return vn2;
      }

    } catch (IOException io) {
      return new String[] { TestSetTool.DEFAULT_NAME };
    }
  }

  /**
   * @param composite
   */
  private void createMyContent(Composite pComposite) {
    fTabVariant = new TestSetComposite(pComposite, getTestSets());
  }

  public boolean performOk() {
    // store prefs
    IPreferenceStore prefStore = getPreferenceStore();
    prefStore.setValue(
      TestSetComposite.RESULT_EXPORT_DIRNAME,
      fTabVariant.getExportFileName());
    prefStore.setValue(
      TestSetComposite.EXPORT_RESULT,
      fTabVariant.exportResult());
    return true;
  }

  public static boolean exportResult() {
    return JlinPlugin.getDefault().getPreferenceStore().getBoolean(
      TestSetComposite.EXPORT_RESULT);
  }

  public static String getResultExportDirName() {
    return JlinPlugin.getDefault().getPreferenceStore().getString(
      TestSetComposite.RESULT_EXPORT_DIRNAME);
  }
}