/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/config/IconKeyCfg.java#2 $
 */


package com.sap.tc.jtools.jlint.eclipse.config;

import com.sap.tc.jtools.jlint.eclipse.resource.AbstractIconKey;

/**
 * centralized management of icon data
 * @version   1.0, $Date: 2004/03/22 $
 * @author    BPL Tools
 */

class IconKeyCfg extends AbstractIconKey {


	static final public IconKeyCfg BAD = new IconKeyCfg(
    "icon/bad.gif"); //$NON-NLS-1$

	static final public IconKeyCfg GOOD = new IconKeyCfg(
    "icon/good.gif"); //$NON-NLS-1$

  static final public IconKeyCfg TEST = new IconKeyCfg(
    "icon/16/test.gif"); //$NON-NLS-1$
    
  static final public IconKeyCfg TEST_PARAM_MISS = new IconKeyCfg(
    "icon/16/args_missing.gif"); //$NON-NLS-1$

  static final public IconKeyCfg TEST_PARAM_NONE = new IconKeyCfg(
    "icon/16/args_no.gif"); //$NON-NLS-1$

  static final public IconKeyCfg TEST_PARAM_OKAY = new IconKeyCfg(
    "icon/16/args_okay.gif"); //$NON-NLS-1$
    
  static final public IconKeyCfg PARAM_TYPE_STRING = new IconKeyCfg(
    "icon/16/text_param.gif"); //$NON-NLS-1$

  static final public IconKeyCfg PARAM_TYPE_ARRAY = new IconKeyCfg(
    "icon/16/array_param.gif"); //$NON-NLS-1$

  static final public IconKeyCfg PARAM_TYPE_DEEP = new IconKeyCfg(
    "icon/16/deep_param.gif"); //$NON-NLS-1$



	/** no instanciation for this class outside itself                          */
	private IconKeyCfg(String pRelativePath) {
		super(pRelativePath, true);
	}
}