/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/config/EditParamDialog.java#2 $
 */

package com.sap.tc.jtools.jlint.eclipse.config;

import java.io.Serializable;
import java.io.StringReader;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;

import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * dialog to enter string values
 * @see InputDialog
 * @version   1.0, $Date: 2004/03/22 $
 * @author    BPL Tools
 */
final class EditParamDialog extends InputDialog {

  final boolean fBigInput;
  final boolean fStructureTree;
  final String paramType;

  /*
   * @see InputDialog#InputDialog()
   */
  public EditParamDialog(
    Shell pParent,
    Serializable pInitialValue,
    boolean pStructureTree,
    String paramType,
    boolean pBigInput) {
    super(
      pParent,
      TextKeyCfg.ENTER_VALUE_TITLE.getText(),
      TextKeyCfg.ENTER_VALUE_HELP.getText(),
      pInitialValue.toString(),
      new ParamValidator(pStructureTree, paramType));
    fBigInput = pBigInput;
    fStructureTree = pStructureTree;
    this.paramType = paramType;
  }

  /*
   * @see InputDialog#createDialogArea(Composite)
   */
  protected Control createDialogArea(Composite pParent) {
    Control resultCtrl = super.createDialogArea(pParent);
    if (fBigInput) {
      Text txt = getText();
      GridData gd = (GridData) txt.getLayoutData();
      gd.heightHint = 200;
      txt.setLayoutData(gd);
    }
    return resultCtrl;
  }

  public Serializable getParamValue() {
    String value = getValue();
    if (ParameterTool.PAR_TYPE_INT.equals(paramType)) {
      return new Integer(Integer.parseInt(value));
    } else if (ParameterTool.PAR_TYPE_FLOAT.equals(paramType)) {
      return new Float(Float.parseFloat(value));
    } else if (ParameterTool.PAR_TYPE_BOOLEAN.equals(paramType)) {
      return Boolean.valueOf(value);
    }
    return value;
  }
  
}

/** internal class for input validation */
class ParamValidator implements IInputValidator {
  final boolean fXMLInput;
  final String paramType;
  public ParamValidator(boolean pXMLInput, String paramType) {
    fXMLInput = pXMLInput;
    this.paramType = paramType;
  }
  public String isValid(String pInput) {
    if (ParameterTool.PAR_TYPE_STRING.equals(paramType)) {
      if (0 >= pInput.length()) {
        return TextKeyCfg.ENTER_VALUE_EMPTY_WARN.getText();
      }
    } else if (ParameterTool.PAR_TYPE_INT.equals(paramType)) {
      try {
        Integer.parseInt(pInput);
      } catch (NumberFormatException e) {
        return TextKeyCfg.ENTER_VALUE_INT_WARN.getText();
      }
    } else if (ParameterTool.PAR_TYPE_FLOAT.equals(paramType)) {
      try {
        Float.parseFloat(pInput);
      } catch (NumberFormatException e) {
        return TextKeyCfg.ENTER_VALUE_FLOAT_WARN.getText();
      }
    }
    if (fXMLInput) {
      try {
        XMLTool.parseReader(new StringReader(pInput));
      } catch (Exception ex) {
        return TextKeyCfg.ENTER_VALUE_XML_WARN.getText();
      }
    }
    return null; // okay
  }
}