/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_eclipse/_core/src/com/sap/tc/jtools/jlint/eclipse/JlinPlugin.java#2 $
 */


package com.sap.tc.jtools.jlint.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import com.sap.tc.jtools.jlint.eclipse.util.ExceptionHandler;

/**
 * The main plugin class to be used in the desktop.
 * @version   1.0, $Date: 2004/03/22 $
 * @author    BPL Tools
 */

public final class JlinPlugin extends AbstractUIPlugin {


  // the shared instance
  private static JlinPlugin fgPlugin;

  /**
   * constructor
   */
  public JlinPlugin(IPluginDescriptor descriptor) {
    super(descriptor);
    fgPlugin = this;
  }

  public static File getInstallDir() {
    URL installUrl = null;
    try {
      installUrl = Platform.resolve(fgPlugin.getDescriptor().getInstallURL());
    } catch (IOException e) {
      ExceptionHandler.handle(e);
    }
    return new File(installUrl.getPath());
  }

  /**
   * @see Plugin#startup()
   */
  public void startup() throws CoreException {
    super.startup();
  }


  /**
   * @see Plugin#shutdown()
   */
  public void shutdown() throws CoreException {
    super.shutdown();
  }

  /**
   * @returns the shared instance of the jver plugin
   */
  public static JlinPlugin getDefault() {
    return fgPlugin;
  }

  /**
   * @returns the unique id of the jlin plugin
   */
  public static String getPluginId() {
    return getDefault().getDescriptor().getUniqueIdentifier();
  }

  /**
   * @returns the workspace instance
   */
  public static IWorkspace getWorkspace() {
    return ResourcesPlugin.getWorkspace();
  }

  /**
   * @returns  null, or actvie workbench shell
   */
  public static Shell getActiveWorkbenchShell() {
    IWorkbenchWindow workBenchWindow = getActiveWorkbenchWindow();
    if (workBenchWindow == null)
      return null;
    return workBenchWindow.getShell();
  }

  /**
   * @return null, the active workbench window
   */
  public static IWorkbenchWindow getActiveWorkbenchWindow() {
    if (null != fgPlugin) {
      IWorkbench workBench = fgPlugin.getWorkbench();
      if (null != workBench) {
        return workBench.getActiveWorkbenchWindow();
      }
    }
    return null;
  }

  /**
   * @return null, or the active page
   */
  public IWorkbenchPage getActivePage() {
    return getActiveWorkbenchWindow().getActivePage();
  }

  /**
   * @returns the active display
   */
  public static Display getDisplay() {
    Shell activeShell = getActiveWorkbenchShell();
    if (null != activeShell) {
      return activeShell.getDisplay();
    }
    Display curDisplay = Display.getCurrent();
    if (null != curDisplay) {
      return curDisplay;
    }
    return Display.getDefault();
  }

  /**
   * @see AbstractUIPlugin#initializeDefaultPreferences()
   */
  protected void initializeDefaultPreferences(IPreferenceStore store) {
    super.initializeDefaultPreferences(store);
  }

  /**
   * Adds an expetion to the eclipse log.
   */
  public static void log(Throwable pException) {
    log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, "Error", //$NON-NLS-1$
    pException));
  }

  /**
   * Adds a logging text to the Eclipse protocoll.
   */
  public static void logInfo(String pInfoStatusText) {
    log(new Status(IStatus.INFO, getPluginId(), IStatus.OK, pInfoStatusText, null));
  }

  /**
   * Adds a status as logging entry to the Eclipse protocoll.
   */
  public static void logDebugInfo(String pInfoText) {
    if (getDefault().isDebugging()) {
      logInfo(pInfoText);
    }
  }

  /**
   * Adds a status as logging entry to the Eclipse protocoll.
   */
  public static void log(IStatus pStatus) {
    getDefault().getLog().log(pStatus);
  }

  /**
   * Returns the path were the Plugin is allowed to store files. Its located
   * in a subdirectory of workspace/.metadata
   */
  public static IPath getBaseDir() {
    return getDefault().getStateLocation();
  }

  /**
   * Returns wether plugin is in debugging state or not.
   */
  public static boolean inDebugMode() {
    return getDefault().isDebugging();
  }



}
