package com.sapmarkets.technology.util.test;

import com.sapmarkets.technology.util.WeakHashSet;
import java.util.Iterator;

public class WeakHashSetTest {

  static WeakHashSet m=new WeakHashSet();

  static public void main(String args[])
  { Iterator i;
    WeakHashSetTest k1=new WeakHashSetTest("key1");
    WeakHashSetTest k2=new WeakHashSetTest("key2");
    WeakHashSetTest k3=new WeakHashSetTest("key3");
    WeakHashSetTest k4=new WeakHashSetTest("key4");

    m.add(k1);
    m.add(k2);
    m.add(k3);
    m.add(k4);

    print();
    check(k1,true);
    check(k2,true);
    check(k3,true);
    check(k4,true);

    m.remove(k4);
    print();
    check(k1,true);
    check(k2,true);
    check(k3,true);
    check(k4,false);

    m.remove(k4);

    k3=null;
    m.remove(null);
    System.gc();
    System.runFinalization();
//    System.gc();
//    System.runFinalization();
//    System.gc();
//    System.runFinalization();
    print();
    check(k1,true);
    check(k2,true);
    check(k3,false);
    check(k4,false);

    k2=null;
    m.remove(null);
    System.gc();
    System.runFinalization();
//    System.gc();
//    System.runFinalization();
//    System.gc();
//    System.runFinalization();
    print();
    check(k1,true);
    check(k2,false);
    check(k3,false);
    check(k4,false);

    k1=null;
    m.remove(null);
    System.gc();
    System.runFinalization();
//    System.gc();
//    System.runFinalization();
//    System.gc();
//    System.runFinalization();
    print();
    check(k1,false);
    check(k2,false);
    check(k3,false);
    check(k4,false);

    System.out.println("end");
  }

  static void print()
  {
    System.out.println("content:");
    Iterator i=m.iterator();
    while (i.hasNext()) {
      System.out.println(": "+i.next());
    }
  }

  static void check(Object k, boolean e)
  {
    if (m.contains(k)!=e) {
      System.out.println("*** "+k+" "+(e?"does not exist":"still exists"));
    }
  }


  String n;

  public WeakHashSetTest(String n)
  { this.n=n;
  }

  public String toString()
  { return n;
  }

  protected void finalize()
  { System.out.println("finalize "+n);
  }
}
