

package com.sapmarkets.technology.util.test;

import com.sapmarkets.technology.util.reg.*;
import java.util.Iterator;

public class RegTest extends RegistrationDestination {

  static class Handler implements RegistrationDestination.IRegistrationHandler {
    RegistrationContainer store=new RegistrationContainer();

    public void notifyRegistration(Registration r)
    {
      System.out.println("+ registration "+r.getObject()+" "+
					   r.getObject().hashCode());
      store.register(r);
    }

    public void notifyUnregistration(Registration r)
    {
      System.out.println("- registration "+r.getObject()+" "+
					   r.getObject().hashCode());
      store.unregister(r);
    }

    void print()
    { Iterator i=store.iterator();
      System.out.println("global registrations:");
      while (i.hasNext()) {
	Registration r=(Registration)i.next();
	System.out.println(" "+r.getObject()+" "+r.getObject().hashCode());
      }
    }
  }

  static class Test {
    public void finalize()
    { System.out.println("finalize");
    }
  }

  static public void main(String args[])
  { Registrations regs=new Registrations();
    Handler handler=new Handler();
    registerRegistrationHandler(handler);

    String s0=new String("String1");
    String s1=new String("String1");
    String s2="String2";
    String s3="String3";

    regs.register(s0);
    regs.register(s1);
    regs.register(s2);
    regs.register(s2);
    regs.register(s3);

    print(regs,"after init");
    handler.print();

    check(regs,s0,true);
    check(regs,s1,true);
    check(regs,s2,true);
    check(regs,s3,true);

    regs.unregister(s0);

    check(regs,s0,false);
    check(regs,s1,true);
    check(regs,s2,true);
    check(regs,s3,true);

    print(regs,"after delete s0");

    Iterator i=regs.iterator();
    Object o;
    while (i.hasNext()) {
      o=i.next();
      if (o==s2) i.remove();
    }
    o=null;
    i=null;

    check(regs,s0,false);
    check(regs,s1,true);
    check(regs,s2,false);
    check(regs,s3,true);

    print(regs,"after iterated delete s2");

    regs.clear();

    check(regs,s0,false);
    check(regs,s1,false);
    check(regs,s2,false);
    check(regs,s3,false);

    print(regs,"after clear");

    ///////////////////////////////////
    regs=new Registrations();
    regs.register(s0);
    regs.register(s1);
    regs.register(s2);
    regs.unregister(s1);

    check(regs,s0,true);
    check(regs,s1,false);
    check(regs,s2,true);

    print(regs,"after init2");
    handler.print();
    regs=null;
    s0=null;
    s1=null;
    s2=null;
    s3=null;
    new Test();

    System.out.println("just forget registrations");
    for (int j=0; j<20; j++) {
      System.gc();
      System.runFinalization();
    }
    handler.print();
  }

  static void print(Registrations regs,String text)
  {
    System.out.println(text);
    Iterator i=regs.iterator();
    while (i.hasNext()) {
      Object o=i.next();
      System.out.println(" "+o+" "+o.hashCode());
    }
  }

  static void check(Registrations regs, Object o, boolean c)
  {
    if (regs.contains(o)!=c) {
      if (c) System.out.println("*** object "+o+" not in set");
      else System.out.println("*** object "+o+" still in set");
    }
  }

}
