package com.sapmarkets.technology.util.test;

import com.sapmarkets.technology.util.*;

import junit.framework.*;

import java.util.*;
import java.text.*;

public class PackageTest extends TestCase
{
    public PackageTest ( String name )
    {
        super ( name );
    }

    public static void main ( String[] args )
    {
        junit.textui.TestRunner.run ( new TestSuite ( PackageTest.class ) );
    }

    protected void setUp ( )
    {
        ;
    }

    protected void tearDown ( )
    {
        ;
    }

    public void testI18N()
    {
        // Safeguard operations
        try
        {
            assert(I18NMgmt.getInstance().getI18NEnvInstance() == I18NMgmt.getInstance().getI18NEnvInstance());
            assert(I18NMgmt.getInstance().getI18NEnvInstance(new Locale("de", "DE", "Extended")) == I18NMgmt.getInstance().getI18NEnvInstance(new Locale("de", "DE", "Extended")));
            II18NEnv env_de = I18NMgmt.getInstance().getI18NEnvInstance(new Locale("de", "DE", "EXTENDED"));
            assertEquals ( env_de.getAssignedLocale().toString(), "de_DE_EXTENDED");
            II18NEnv env_en = I18NMgmt.getInstance().getI18NEnvInstance(new Locale("en", "US"));
            assertEquals ( env_en.getAssignedLocale().toString(), "en_US");


            env_de.setMessageBase ( "titles" );
            env_en.setMessageBase ( "titles" );
            assertEquals ( env_de.formatMessageUsingDefaultIfUnavailable("buttons", "myList", "Liste ({0})", new Object[]{env_de.getMessageUsingDefaultIfUnavailable ("myListLocale", "-")}), "Liste (-)");
            assertEquals ( env_en.formatMessageUsingDefaultIfUnavailable("myList", "List ({0})", new Object[]{env_en.getMessageUsingDefaultIfUnavailable ("titles", "myListLocale", "-")}), "List (-)");
            assertEquals ( env_de.formatMessage("buttons", "myButton", new Object[]{env_de.getMessage("buttons", "myButtonLocale")}), "Knopf (de_DE_Extended)");
            assertEquals ( env_en.formatMessage("buttons", "myButton", new Object[]{env_en.getMessage("buttons", "myButtonLocale")}), "Button (en_US)");
            assertEquals ( env_de.formatMessage("myTitle", new Object[]{env_de.getMessage("myTitleLocale")}), "Titel (de_DE_Extended)");
            assertEquals ( env_en.formatMessage("myTitle", new Object[]{env_en.getMessage("myTitleLocale")}), "Title (en_US)");


            Date dateVal = new Date();
            assertEquals ( env_de.formatDate(dateVal), new SimpleDateFormat(env_de.DATE_PATTERN_DEFAULT).format(dateVal) );
            assertEquals ( env_en.formatDate(dateVal.getTime()), new SimpleDateFormat(env_en.DATE_PATTERN_DEFAULT).format(dateVal) );
            env_de.setDateFormat ( "dd.MM.yyyy HH:mm" );
            env_en.setDateFormat ( II18NEnv.DATETIME_STYLE_SHORT, II18NEnv.DATETIME_STYLE_SHORT );
            assertEquals ( env_de.formatDate(dateVal), new SimpleDateFormat("dd.MM.yyyy HH:mm").format(dateVal) );
            assertEquals ( env_en.formatDate(dateVal.getTime()), DateFormat.getDateTimeInstance (II18NEnv.DATETIME_STYLE_SHORT, II18NEnv.DATETIME_STYLE_SHORT, env_en.getAssignedLocale()).format(dateVal) );
            assertEquals ( env_de.formatDate(dateVal, "dd.MM.yyyy HH:mm:ss:SSSS"), new SimpleDateFormat("dd.MM.yyyy HH:mm:ss:SSSS").format(dateVal) );
            assertEquals ( env_de.formatDate(dateVal.getTime(), "dd.MM.yyyy HH:mm:ss:SSSS"), new SimpleDateFormat("dd.MM.yyyy HH:mm:ss:SSSS").format(dateVal) );
            assertEquals ( env_en.formatDate(dateVal, II18NEnv.DATETIME_STYLE_FULL, II18NEnv.DATETIME_STYLE_NONE), DateFormat.getDateInstance (II18NEnv.DATETIME_STYLE_FULL, env_en.getAssignedLocale()).format(dateVal) );
            assertEquals ( env_en.formatDate(dateVal.getTime(), II18NEnv.DATETIME_STYLE_NONE, II18NEnv.DATETIME_STYLE_FULL), DateFormat.getTimeInstance (II18NEnv.DATETIME_STYLE_FULL, env_en.getAssignedLocale()).format(dateVal) );


            Double doubleVal = new Double(123.456);
            assertEquals ( env_de.formatCurrency(doubleVal), NumberFormat.getCurrencyInstance (env_de.getAssignedLocale()).format(doubleVal) );
            assertEquals ( env_en.formatCurrency(doubleVal.longValue()), NumberFormat.getCurrencyInstance (env_en.getAssignedLocale()).format(doubleVal.longValue()) );
            env_de.setCurrencyFormat ( 5,5,6, Integer.MAX_VALUE );
            env_en.setCurrencyFormat ( 5,5,6, Integer.MAX_VALUE );
            NumberFormat currencyFormat_de = NumberFormat.getCurrencyInstance (env_de.getAssignedLocale());
            currencyFormat_de.setMinimumFractionDigits(5);
            currencyFormat_de.setMaximumFractionDigits(5);
            currencyFormat_de.setMinimumIntegerDigits(6);
            currencyFormat_de.setMaximumIntegerDigits(Integer.MAX_VALUE);
            NumberFormat currencyFormat_en = NumberFormat.getCurrencyInstance (env_en.getAssignedLocale());
            currencyFormat_en.setMinimumFractionDigits(5);
            currencyFormat_en.setMaximumFractionDigits(5);
            currencyFormat_en.setMinimumIntegerDigits(6);
            currencyFormat_en.setMaximumIntegerDigits(Integer.MAX_VALUE);
            assertEquals ( env_de.formatCurrency(doubleVal), currencyFormat_de.format(doubleVal) );
            assertEquals ( env_en.formatCurrency(doubleVal.longValue()), currencyFormat_en.format(doubleVal.longValue()) );
            assertEquals ( env_de.formatCurrency(doubleVal, 5,5,6, Integer.MAX_VALUE ), currencyFormat_de.format(doubleVal) );
            assertEquals ( env_en.formatCurrency(doubleVal.longValue(), 5,5,6, Integer.MAX_VALUE ), currencyFormat_en.format(doubleVal.longValue()) );

            assertEquals ( env_de.formatNumber(doubleVal), NumberFormat.getNumberInstance (env_de.getAssignedLocale()).format(doubleVal) );
            assertEquals ( env_en.formatNumber(doubleVal.longValue()), NumberFormat.getNumberInstance (env_en.getAssignedLocale()).format(doubleVal.longValue()) );
            env_de.setNumberFormat ( 5,5,6, Integer.MAX_VALUE );
            env_en.setNumberFormat ( 5,5,6, Integer.MAX_VALUE );
            NumberFormat numberFormat_de = NumberFormat.getNumberInstance (env_de.getAssignedLocale());
            numberFormat_de.setMinimumFractionDigits(5);
            numberFormat_de.setMaximumFractionDigits(5);
            numberFormat_de.setMinimumIntegerDigits(6);
            numberFormat_de.setMaximumIntegerDigits(Integer.MAX_VALUE);
            NumberFormat numberFormat_en = NumberFormat.getNumberInstance (env_en.getAssignedLocale());
            numberFormat_en.setMinimumFractionDigits(5);
            numberFormat_en.setMaximumFractionDigits(5);
            numberFormat_en.setMinimumIntegerDigits(6);
            numberFormat_en.setMaximumIntegerDigits(Integer.MAX_VALUE);
            assertEquals ( env_de.formatNumber(doubleVal), numberFormat_de.format(doubleVal) );
            assertEquals ( env_en.formatNumber(doubleVal.longValue()), numberFormat_en.format(doubleVal.longValue()) );
            assertEquals ( env_de.formatNumber(doubleVal, 5,5,6, Integer.MAX_VALUE ), numberFormat_de.format(doubleVal) );
            assertEquals ( env_en.formatNumber(doubleVal.longValue(), 5,5,6, Integer.MAX_VALUE ), numberFormat_en.format(doubleVal.longValue()) );

            assertEquals ( env_de.formatPercent(doubleVal), NumberFormat.getPercentInstance (env_de.getAssignedLocale()).format(doubleVal) );
            assertEquals ( env_en.formatPercent(doubleVal.longValue()), NumberFormat.getPercentInstance (env_en.getAssignedLocale()).format(doubleVal.longValue()) );
            env_de.setPercentFormat ( 5,5,6, Integer.MAX_VALUE );
            env_en.setPercentFormat ( 5,5,6, Integer.MAX_VALUE );
            NumberFormat percentFormat_de = NumberFormat.getPercentInstance (env_de.getAssignedLocale());
            percentFormat_de.setMinimumFractionDigits(5);
            percentFormat_de.setMaximumFractionDigits(5);
            percentFormat_de.setMinimumIntegerDigits(6);
            percentFormat_de.setMaximumIntegerDigits(Integer.MAX_VALUE);
            NumberFormat percentFormat_en = NumberFormat.getPercentInstance (env_en.getAssignedLocale());
            percentFormat_en.setMinimumFractionDigits(5);
            percentFormat_en.setMaximumFractionDigits(5);
            percentFormat_en.setMinimumIntegerDigits(6);
            percentFormat_en.setMaximumIntegerDigits(Integer.MAX_VALUE);
            assertEquals ( env_de.formatPercent(doubleVal), percentFormat_de.format(doubleVal) );
            assertEquals ( env_en.formatPercent(doubleVal.longValue()), percentFormat_en.format(doubleVal.longValue()) );
            assertEquals ( env_de.formatPercent(doubleVal, 5,5,6, Integer.MAX_VALUE ), percentFormat_de.format(doubleVal) );
            assertEquals ( env_en.formatPercent(doubleVal.longValue(), 5,5,6, Integer.MAX_VALUE ), percentFormat_en.format(doubleVal.longValue()) );
        }
        catch( Exception exception )
        {
            exception.printStackTrace();
            assert(false);
        }
    }
}
