

package com.sapmarkets.technology.util.reg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.AbstractSet;

/**
 * keep registrations for objects. A Registrations object acts
 * like a HashSet based on the objects identity (not the equals method).
 * It calls the global registration handler for added and removed
 * objects. Such a registration handler may decide to remove entries
 * at any time. This is used for the application manager to remove
 * objects provided by an application, if this application disappears.
 */
public class Registrations extends AbstractSet {

  private class RegistrationsRegistration extends SimpleRegistration {
    private int hashcode;

    RegistrationsRegistration(Object o)
    { super(o);
    }

    protected void setObject(Object o)
    { if (o!=null) hashcode=o.hashCode();
      super.setObject(o);
    }

    protected void handleUnregister()
    { 
      Registrations.this.unregister(getObject());
    }

    public boolean equals(Object o)
    { if (o==this) return true;
      if (o instanceof RegistrationsRegistration) {
	return ((RegistrationsRegistration)o).getObject()==getObject();
      }
      return o==getObject();
    }

    public int hashCode()
    { return hashcode;
    }

    public String toString()
    { return "registrations registration for "+getObject();
    }
  }

  private HashMap registrations=new HashMap();
  private RegistrationsRegistration compare=new RegistrationsRegistration(null);
  

  synchronized
  public boolean register(Object o)
  { RegistrationsRegistration r=new RegistrationsRegistration(o);
    if (registrations.containsKey(r)) return false;
    RegistrationDestination.inc(r);
    registrations.put(r,r);
    return true;
  }

  synchronized
  public boolean unregister(Object o)
  { RegistrationsRegistration r;

    compare.setObject(o);
    r=(RegistrationsRegistration)registrations.get(compare);
    registrations.remove(compare);
    if (r!=null) {
      RegistrationDestination.dec(r);
      return true;
    }
    return false;
  }

  public boolean add(Object o)
  { return register(o);
  }

  public boolean remove(Object o)
  { return unregister(o);
  }

  synchronized
  public void clear()
  { Iterator i=iterator();
    while (i.hasNext()) {
      i.next();
      i.remove();
    }
  }

  synchronized
  public boolean contains(Object o)
  { compare.setObject(o);
    return registrations.containsKey(compare);
  }

  synchronized
  public int size()
  { return registrations.size();
  }

  synchronized
  public boolean isEmpty()
  { return registrations.isEmpty();
  }

  public Iterator iterator()
  { return new RegistrationIterator();
  }

  private class RegistrationIterator implements Iterator { 
    Iterator i;
    RegistrationsRegistration last;

    RegistrationIterator()
    { i=registrations.keySet().iterator();
    }

    public boolean hasNext()
    { synchronized (Registrations.this) {
	return i.hasNext();
      }
    }

    public Object next()
    { synchronized (Registrations.this) {
	last=(RegistrationsRegistration)i.next();
	if (last!=null) return last.getObject();
	return null;
      }
    }

    public void remove()
    { synchronized (Registrations.this) {
	i.remove();
	if (last!=null) RegistrationDestination.dec(last);
      }
    }
  }
}
