

package com.sapmarkets.technology.util.reg;

import java.util.Vector;

public abstract class RegistrationDestination {

  protected static void inc(Registration r)
  { r.inc();
  }

  protected static void dec(Registration r)
  { r.dec();
  }

  /**
   * registrations handlers can be used by components managing
   * own class loaders to determine registrations of class loader
   * local objects as handlers for the profile management.
   * It is then the task of this handle to unregister all the
   * local registration handlers, when the class loader becomes
   * obsolete!
   */
  static public interface IRegistrationHandler {
    void notifyRegistration(Registration r);
    void notifyUnregistration(Registration r);
  }

  static private class RegistrationRegistration extends SimpleRegistration {
    RegistrationRegistration(IRegistrationHandler h)
    { super(h);
    }

    IRegistrationHandler getRegistrationHandler()
    { return (IRegistrationHandler)getObject();
    }

    protected void handleUnregister()
    { 
      unregisterRegistrationHandler(getRegistrationHandler());
    }

    public String toString()
    { return "registration registration for "+getObject();
    }
  }

  static private Vector registrations=new Vector();
  static private boolean busy=false;

  synchronized
  static public void registerRegistrationHandler(IRegistrationHandler h)
  { int size=registrations.size();
    Registration r;

    for (int i=0; i<size; i++) {
      r=(Registration)registrations.elementAt(i);
      if (r.getObject()==h) return;
    }
    r=new RegistrationRegistration(h);
    inc(r);
    registrations.add(r);
  }

  synchronized
  static public void unregisterRegistrationHandler(IRegistrationHandler h)
  { 
    if (busy) {
      registrations=(Vector)registrations.clone();
      busy=false;
    }
    int size=registrations.size();
    for (int i=0; i<size; i++) {
      Registration r=(Registration)registrations.elementAt(i);
      if (r.getObject()==h) {
	registrations.removeElementAt(i);;
	dec(r);
      }
    }
  }

  synchronized
  static void notifyRegistration(Registration reg)
  { Vector regs=registrations;
    int size=regs.size();
    busy=true;

    for (int i=0; i<size; i++) {
      RegistrationRegistration r=(RegistrationRegistration)regs.elementAt(i);
      r.getRegistrationHandler().notifyRegistration(reg);
    }
    busy=false;
  }

  synchronized
  static void notifyUnRegistration(Registration reg)
  { Vector regs=registrations;
    int size=regs.size();
    busy=true;

    for (int i=0; i<size; i++) {
      RegistrationRegistration r=(RegistrationRegistration)regs.elementAt(i);
      r.getRegistrationHandler().notifyUnregistration(reg);
    }
    busy=false;
  }
}
