

package com.sapmarkets.technology.util.reg;

import java.util.HashSet;
import java.util.Iterator;
import java.util.AbstractSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.ref.Reference;

/**
 * keep registrations for objects as weak references.
 */
public class RegistrationContainer extends AbstractSet {

  private class RegistrationRef extends WeakReference {
    private int hash;

    RegistrationRef(Object o)
    { super(o,queue);
      hash=o.hashCode();
    }

    public Registration getRegistration()
    { return (Registration)get();
    }

    public boolean equals(Object o)
    { Object me=get();
      if (me==null) {
	cleanup.add(this);
	return false;
      }
      if (o==this) return true;
      if (o instanceof RegistrationRef) {
	Object you=((RegistrationRef)o).get();
	if (you==null) {
	  cleanup.add(o);
	  return false;
	}
	return you==me;
      }
      return o==me;
    }

    public int hashCode()
    { if (get()==null) cleanup.add(this);
      return hash;
    }

    public String toString()
    { return "registrations registration for "+get();
    }
  }

  private ReferenceQueue queue=new ReferenceQueue();
  private HashSet cleanup=new HashSet();
  private HashSet registrations=new HashSet();
  
  synchronized
  private void cleanup()
  { Iterator i;
    HashSet s;
    Reference r;

    if (cleanup.isEmpty()) {
      i=cleanup.iterator();
      cleanup=new HashSet();
      while (i.hasNext()) {
	registrations.remove(i.next());
      }
    }
    while ((r=queue.poll())!=null) {
      remove(r);
    }
  }


  public boolean unregister(Registration r)
  { if (r!=null) {
      RegistrationRef ref=new RegistrationRef(r);
      if (!registrations.contains(ref)) return false;
      registrations.remove(ref);
      cleanup();
      return true;
    }
    return false;
  }

  public boolean register(Registration r)
  { if (r!=null) {
      RegistrationRef ref=new RegistrationRef(r);
      if (registrations.contains(ref)) return false;
      registrations.add(ref);
      cleanup();
      return true;
    }
    return false;
  }

  public boolean add(Object o)
  { return register((Registration)o);
  }

  public boolean remove(Object o)
  { return unregister((Registration)o);
  }

  synchronized
  public void clear()
  { Iterator i=iterator();
    while (i.hasNext()) {
      i.next();
      i.remove();
    }
  }

  synchronized
  public boolean contains(Object o)
  { 
    if (o instanceof Registration) {
      return registrations.contains(new RegistrationRef(o));
    }
    return false;
  }

  synchronized
  public int size()
  { return registrations.size();
  }

  synchronized
  public boolean isEmpty()
  { return registrations.isEmpty();
  }

  public Iterator iterator()
  { return new RegistrationIterator();
  }

  private class RegistrationIterator implements Iterator { 
    Iterator i;
    Registration next;

    RegistrationIterator()
    { i=registrations.iterator();
      _next();
    }

    synchronized
    private void _next()
    { next=null;
      while (next==null && i.hasNext()) {
	next=((RegistrationRef)i.next()).getRegistration();
      }
    }

    public boolean hasNext()
    { return next!=null; 
    }

    public Object next()
    { Object n=next;
      _next();
      return n;
    }

    public void remove()
    { throw new UnsupportedOperationException(); 
    }
  }
}
